<?php
namespace Modules\AboutUs\Repositories;

use Modules\AboutUs\Entities\AboutUs;
use Modules\AboutUs\Repositories\AboutUsInterface;
use Modules\AboutUs\Repositories\AboutUsRepository;


class AboutUsRepository implements AboutUsInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = AboutUs::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return AboutUs::find($id);
    }

   public function getList(){
       $result = AboutUs::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return AboutUs::create($data);
    }

    public function update($id,$data){
        $result = AboutUs::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return AboutUs::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . AboutUs::FILE_PATH, $fileName);
        $fileName=AboutUs::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveAboutUs()
    {
       return AboutUs::where('status',1)->get();
    }

}
