<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAboutussTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('aboutuss', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();

            $table->string('email')->nullable();
            $table->string('image')->nullable();
            $table->string('fav_icon')->nullable();
            $table->string('logo')->nullable();
            $table->string('company_name')->nullable();
            $table->longText('description')->nullable();
            $table->text('highlighted_text')->nullable();
            $table->text('short_description')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keyword')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('fb_link')->nullable();
            $table->string('twitter_link')->nullable();
            $table->string('insta_link')->nullable();
            $table->string('googleplus_link')->nullable();
            $table->string('map')->nullable();



           $table->integer('sort_order')->nullable();


           $table->boolean('status')->default(1);

           $table->bigInteger('created_by')->unsigned()->nullable();

           $table->bigInteger('updated_by')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('aboutuss');
    }
}
