@extends('layouts.backmaster')

@section('title', 'Sarathi Holidays')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
    <table style="width:100%">
        <tr>
            <th class="headtext">
                About Us
            </th>
            <th class="float-right">
                <a href="{{ route('aboutus.index') }}" class="btn btn-outline-primary pull-right">
                    List</a>
            </th>
        </tr>
    </table>
@endsection

@section('seccontent')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if (!isset($aboutus->id))
                        <form method="post" action="{{ route('aboutus.store') }}" enctype="multipart/form-data"
                            class="valid_form">
                            <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('aboutus.update', $aboutus) }}" method="post"
                                enctype="multipart/form-data" class="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                {{-- <input type="hidden" class="form-control" name="created_by" value="{{$aboutus->created_by}}">
                        --}}
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Title:</label>
                                <input type="text" name="title" class="form-control"
                                    value="{{ old('title', $aboutus->title) }}" required>
                                @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="title"> Meta Title:</label>
                                <input type="text" name="meta_title" class="form-control"
                                    value="{{ old('meta_title', $aboutus->meta_title) }}" required>
                                @if ($errors->has('meta_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="title"> Meta Keyword:</label>
                                <input type="text" name="meta_keyword" class="form-control"
                                    value="{{ old('meta_keyword', $aboutus->meta_keyword) }}" required>
                                @if ($errors->has('meta_keyword'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_keyword') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="title"> Highlighted Text:</label>
                                <input type="text" name="highlighted_text" class="form-control"
                                    value="{{ old('highlighted_text', $aboutus->highlighted_text) }}" required>
                                @if ($errors->has('highlighted_text'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('highlighted_text') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="email">Email:</label>
                                <input type="email" name="email" class="form-control"
                                    value="{{ old('email', $aboutus->email) }}" required>
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                    </div>

                    <div class="row">

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" class="form-control dropify" name="image" value=""
                                    data-default-file="{{ $aboutus->image ? asset($aboutus->image) : '' }}">
                                @if (isset($aboutus->id))
                                    <img src="{{ asset($aboutus->image) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label>Landing About Image :</label>
                                <input type="file" class="form-control dropify" name="landing_about_image" value=""
                                    data-default-file="{{ $aboutus->landing_about_image ? asset($aboutus->landing_about_image) : '' }}">
                                @if (isset($aboutus->id))
                                    <img src="{{ asset($aboutus->landing_about_image) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label>Why Us Image :</label>
                                <input type="file" class="form-control dropify" name="why_us_image" value=""
                                    data-default-file="{{ $aboutus->why_us_image ? asset($aboutus->why_us_image) : '' }}">
                                @if (isset($aboutus->id))
                                    <img src="{{ asset($aboutus->why_us_image) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label>Logo :</label>
                                <input type="file" class="form-control dropify" name="logo" value=""
                                    data-default-file="{{ $aboutus->logo ? asset($aboutus->logo) : '' }}">
                                @if (isset($aboutus->id))
                                    <img src="{{ asset($aboutus->logo) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label>Fav Icon :</label>
                                <input type="file" class="form-control dropify" name="fav_icon" value=""
                                    data-default-file="{{ $aboutus->fav_icon ? asset($aboutus->fav_icon) : '' }}">
                                @if (isset($aboutus->id))
                                    <img src="{{ asset($aboutus->fav_icon) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>



                    </div>
                    <div class="row">

                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="description">Description:</label>
                                <textarea name="description" id="" class="my-editor" cols="30" rows="10">{{ old('description', $aboutus->description) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                        value="{{old('link',$aboutus->link)}}" required> --}}
                                @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="why_us">Why Us:</label>
                                <textarea name="why_us" id="" class="my-editor" cols="30" rows="10">{{ old('why_us', $aboutus->why_us) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                        value="{{old('link',$aboutus->link)}}" required> --}}
                                @if ($errors->has('why_us'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('why_us') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="company_name">Company Name:</label>
                                <input type="text" name="company_name" class="form-control"
                                    value="{{ old('company_name', $aboutus->company_name) }}" required>
                                @if ($errors->has('company_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('company_name') }}</strong>
                                    </span>
                                @endif
                            </div>

                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="phone">Phone:</label>
                                <input type="text" name="phone" class="form-control"
                                    value="{{ old('phone', $aboutus->phone) }}" required>
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>

                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="address">Address:</label>
                                <input type="text" name="address" class="form-control"
                                    value="{{ old('address', $aboutus->address) }}" required>
                                @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                            </div>

                        </div>
                    </div>
                    <div class="row">


                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="sort_order"> Sort Order:</label>
                                <input type="number" name="sort_order" class="form-control"
                                    value="{{ old('sort_order', $aboutus->sort_order) }}" required>
                                @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="short_description"> Landing Page Description:</label>
                                {{-- <input type="text" name="short_description" class="form-control"
                                        value="{{old('short_description',$aboutus->short_description)}}" required> --}}
                                <textarea name="landing_description" required id="" cols="30" rows="10">{{ old('landing_description', $aboutus->landing_description) }}</textarea>
                                @if ($errors->has('landing_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('landing_description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="short_description"> Short Description:</label>
                                {{-- <input type="text" name="short_description" class="form-control"
                                        value="{{old('short_description',$aboutus->short_description)}}" required> --}}
                                <textarea name="short_description" required id="" cols="30" rows="10">{{ old('short_description', $aboutus->short_description) }}</textarea>
                                @if ($errors->has('short_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('short_description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="fb_link"> Fb Link:</label>
                                <input type="text" name="fb_link" class="form-control"
                                    value="{{ old('fb_link', $aboutus->fb_link) }}" required>
                                @if ($errors->has('fb_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fb_link') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                    </div>
                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="twitter_link"> Twitter Link:</label>
                                <input type="text" name="twitter_link" class="form-control"
                                    value="{{ old('twitter_link', $aboutus->twitter_link) }}" required>
                                @if ($errors->has('twitter_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('twitter_link') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="insta_link"> Insta Link:</label>
                                <input type="text" name="insta_link" class="form-control"
                                    value="{{ old('insta_link', $aboutus->insta_link) }}" required>
                                @if ($errors->has('insta_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('insta_link') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="googleplus_link"> Google Plus Link:</label>
                                <input type="text" name="googleplus_link" class="form-control"
                                    value="{{ old('googleplus_link', $aboutus->googleplus_link) }}" required>
                                @if ($errors->has('googleplus_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('googleplus_link') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="meta_description"> Meta Description:</label> <br>
                                <textarea name="meta_description" id="">{{ old('meta_description', $aboutus->meta_description) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                        value="{{old('link',$aboutus->link)}}" required> --}}
                                @if ($errors->has('meta_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-8 col-xs-12">
                            <div class="form-group ">
                                <label for="map"> Map:</label>
                                <input type="text" name="map" class="form-control"
                                    value="{{ old('map', $aboutus->map) }}" required>
                                @if ($errors->has('map'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('map') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status:</label><br>
                                <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                <input type="radio" name="status" id="status" value="0"
                                    {{ $aboutus->status == '0' ? 'checked' : '' }}> Inactive
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <div class="col-md-12">
                            <button class="btn btn-outline-success float-right">Save</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
