@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('content_header')
@stop

@section('csssec')
@stop

@section('jssec')
@stop

@section('seccontent')
<div class="container">
    <div class="row">
        <div class="col-md-10">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <a href="{{route('aboutus.index')}}" class="btn btn-outline-primary pull-right"> List</a>
                    <h1>Detail Page</h1>
                </div>

                <div class="panel-body">
                    <table class="table table-bordered ">
                        <tr>
                            <th>Title</th>
                            <td>{{$aboutus->title}}</td>
                        </tr>
                        <tr>
                            <th>Highlighted Text</th>
                            <td>{{$aboutus->highlighted_text}}</td>
                        </tr>
                        <tr>
                            <th> Meta Title</th>
                            <td>{{$aboutus->meta_title}}</td>
                        </tr>
                        <tr>
                            <th> Meta Keyword</th>
                            <td>{{$aboutus->meta_keyword}}</td>
                        </tr>
                        <tr>
                            <th> Meta Description</th>
                            <td>{!! $aboutus->meta_description!!}</td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td>{{$aboutus->email}}</td>
                        </tr>
                        <tr>
                            <th>Image</th>
                            <td>
                                <img src="{{asset($aboutus->image)}}" height="100" width="150">

                            </td>
                        </tr>
                        <tr>
                            <th>Fav Icon</th>
                            <td>
                                <img src="{{asset($aboutus->fav_icon)}}" height="100" width="150">

                            </td>
                        </tr>
                        <tr>
                            <th>Logo</th>
                            <td>
                                <img src="{{asset($aboutus->logo)}}" height="100" width="150">

                            </td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td>{!!$aboutus->description!!}</td>
                        </tr>
                        <tr>
                            <th>Why Us</th>
                            <td>{!!$aboutus->why_us!!}</td>
                        </tr>
                        <tr>
                            <th>Sort Order</th>
                            <td>{{$aboutus->sort_order}}</td>
                        </tr>
                        <tr>
                            <th>Company Name</th>
                            <td>{{$aboutus->company_name}}</td>
                        </tr>
                        <tr>
                            <th>Phone</th>
                            <td>{{$aboutus->phone}}</td>
                        </tr>
                        <tr>
                            <th>Address</th>
                            <td>{{$aboutus->address}}</td>
                        </tr>
                        <tr>
                            <th>Fb Link</th>
                            <td>{{$aboutus->fb_link}}</td>
                        </tr>
                        <tr>
                            <th>Twitter Link</th>
                            <td>{{$aboutus->twitter_link}}</td>
                        </tr>
                        <tr>
                            <th>Insta Link</th>
                            <td>{{$aboutus->insta_link}}</td>
                        </tr>
                        <tr>
                            <th>Google Plus Link</th>
                            <td>{{$aboutus->googleplus_link}}</td>
                        </tr>
                        <tr>
                            <th>Map</th>
                            <td>{{$aboutus->map}}</td>
                        </tr>

                        <tr>
                            <th>Short Description</th>
                            <td>{{$aboutus->short_description}}</td>
                        </tr>
                        @if ($aboutus->createdBy)
                        <tr>
                            <th>Created By</th>
                            <td>{{$aboutus->createdBy->name}}</td>
                        </tr>
                        @endif
                        @if ($aboutus->updatedBy)
                        <tr>
                            <th>Updated By</th>
                            <td>{{$aboutus->updatedBy->name}}</td>
                        </tr>

                        @endif



                        <tr>
                            <th>Status</th>
                            <td>
                                @if($aboutus->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <a href="{{route('aboutus.edit', $aboutus)}}" class="btn btn-outline-primary"><i
                                        class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                            </td>
                            <td>
                                <form action="{{route('aboutus.destroy', $aboutus->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger"><i
                                            class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>
                                </form>

                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
