@extends('layouts.master')

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Module List
        </th>
        <th class=" float-right">
            <a href="{{route('module.index')}}" class="btn uniform_use_button float-right">List
                Module</a>
        </th>
    </tr>
</table>
@endsection

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    <form method="post" action="{{route('module.store')}}" enctype="multipart/form-data"
                        id="module_form">
                        {{csrf_field()}}
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" name="name" id="name" required>
                            @if ($errors->has('name'))
                            <span class="help-block">
                                <strong>{{ $errors->first('name') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div class="form-group">
                            <label for="url">URL</label>
                            <input type="text" class="form-control" name="url" id="url">
                            @if($errors->has('url'))
                                <div class="alert alert-danger">
                                    {{$errors->first('url')}}
                                </div>
                            @endif
                        </div>
                        <div class="form-group">
                            <label>Status</label>
                            <input type="radio" name="status" value="1" checked> Active
                            <input type="radio" name="status" value="0"> Inactive
                        </div>
                        <div class="form-group">
                            <input class="btn uniform_use_button float-right" type="submit" name="submit" value="Save Module">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
