@extends('layouts.master')

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Module List
        </th>
        <th class=" float-right">
            <a href="{{route('module.index')}}" class="btn uniform_use_button float-right">List
                Module</a>
        </th>
    </tr>
</table>
@endsection

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    <form method="post" action="{{route('module.update',$module)}}" method="post" id="module_form">
                        <input type="hidden" name="_method" value="put">
                        {{csrf_field()}}
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" name="name" value="{{$module->name}}" id="name"
                                required>
                            @if ($errors->has('name'))
                            <span class="help-block">
                                <strong>{{ $errors->first('name') }}</strong>
                            </span>
                            @endif

                        </div>
                        <div class="form-group">
                            <label for="url">URL</label>
                            <input type="text" class="form-control" name="url" value="{{$module->url}}" id="url">
                            @if ($errors->has('url'))
                            <span class="help-block">
                                <strong>{{ $errors->first('url') }}</strong>
                            </span>
                            @endif

                        </div>

                        <div class="form-group">
                            <label>Status</label>
                            @if($module->status==1)
                                <input type="radio" name="status" value="1" checked> Active
                                <input type="radio" name="status" value="0"> Inactive
                            @else
                                <input type="radio" name="status" value="1"> Active
                                <input type="radio" name="status" value="0" checked> Inactive
                            @endif
                        </div>
                        <div class="form-group">
                            <input class="btn uniform_use_button float-right" type="submit" name="submit" value="Update Module">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
