@extends('layouts.master')
@section('css')
<link type="text/css" rel="stylesheet" href="{{asset('assets/datatables/css/jquery.dataTables.min.css')}}">
@endsection

@section('javascript')
<script type="text/javascript" src="{{asset('assets/datatables/js/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#module_table').DataTable();
    });

</script>
@endsection
@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Module List
        </th>
        <th class=" float-right">
            <a href="{{route('module.create')}}" class="btn uniform_use_button float-right">Create
                Module</a>
        </th>
    </tr>
</table>
@endsection

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if(Session::has('success'))
                    <div class="alert alert-success">
                        {{ Session::get('success') }}
                    </div>
                    @endif
                    @if(Session::has('error'))
                    <div class="alert alert-danger">
                        {{ Session::get('error') }}
                    </div>
                    @endif
                    <table class="table table-bordered" id="module_table">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>URL</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php($i=1)
                            @foreach($module as $m)
                            <tr>

                                <td>{{$i++}}</td>
                                <td>{{$m->name}}</td>
                                <td>{{$m->url}}</td>
                                <td>
                                    @if($m->status==1)
                                    <label class="label label-success">Active</label>
                                    @else
                                    <label class="label label-danger">Inactive</label>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{route('module.edit',$m)}}" class="btn btn-outline-warning" data-toggle="tooltip"
                                        title="Edit Info">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 24 24">
                                        <g fill="none" stroke="#04347a" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1" />
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3" />
                                        </g>
                                    </svg>
                               </a>

                                    {{-- <a href="#" data-toggle="tooltip" title="View Detail" class="btn btn-outline-warning"><i
                                            class="fa fa-eye"></i></a> --}}
                                    <form action="{{route('module.destroy',$m)}}" method="POST"
                                        onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                        <input type="hidden" name="_method" value="delete">
                                        {{csrf_field()}}
                                        <button type="submit" class="btn btn-outline-danger" data-toggle="tooltip"
                                            title="Delete Information"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
