<?php

use Illuminate\Support\Facades\Route;
use Modules\AclManagement\Http\Controllers\RoleController;
use Modules\UserManagement\Http\Controllers\UserController;
use Modules\AclManagement\Http\Controllers\ModuleController;
use Modules\AclManagement\Http\Controllers\PermissionController;
use Modules\AclManagement\Http\Controllers\AclManagementController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::group([], function () {
//     Route::resource('aclmanagement', AclManagementController::class)->names('aclmanagement');
// });
Route::group(['prefix' => 'backend/v1/', 'middleware' => ['auth','defaultpermission']], function ()
    {
// Route::get('/systemsetting', 'HomeController@systemsetting')->name('back.systemsetting');
Route::resource('/role', RoleController::class);
Route::resource('/permission', PermissionController::class);
Route::resource('/module', ModuleController::class);
// Route::resource('/role', 'RoleController');
// Route::resource('/permission', 'PermissionController');
// Route::resource('/module', 'ModuleController');

// Route::resource('/user', 'UserController');
Route::post('userinactive', [UserController::class,'inactiveindex'])->name('user.inactiveindex');
Route::get('/assignpermission/{id}', [RoleController::class,'assign'])->name('role.assignpermission');
Route::post('/saverolepermission/{id}', [RoleController::class,'assign_permission'])->name('role.saverolepermission');
Route::get('/assignrole/{id}', [UserController::class,'assign'])->name('user.assignrole');
Route::post('/saveroleuser/{id}', [UserController::class,'assign_role'])->name('user.saveroleuser');
Route::get('/assignmodule/{id}', [RoleController::class,'assignmodule'])->name('role.assignmodule');
Route::post('/saverolemodule/{id}', [RoleController::class,'assign_module'])->name('role.saverolemodule');
Route::get('userchangestatus/{id}', [UserController::class,'changestatus'])->name('userchangestatus');

// Route::get('userinactive', 'UserController@inactiveindex')->name('user.inactiveindex');
// Route::get('/assignpermission/{id}', 'RoleController@assign')->name('role.assignpermission');
// Route::post('/saverolepermission/{id}', 'RoleController@assign_permission')->name('role.saverolepermission');
// Route::get('/assignrole/{id}', 'UserController@assign')->name('user.assignrole');
// Route::post('/saveroleuser/{id}', 'UserController@assign_role')->name('user.saveroleuser');
// Route::get('/assignmodule/{id}', 'RoleController@assignmodule')->name('role.assignmodule');
// Route::post('/saverolemodule/{id}', 'RoleController@assign_module')->name('role.saverolemodule');
// Route::get('userchangestatus/{id}', 'UserController@changestatus')->name('userchangestatus');

});
