<?php

namespace Modules\AssociatedOrganization\Entities;

use App\User;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AssociatedOrganization extends Model
{
    const FILE_PATH='/uploads/associatedorganization/';
    protected $table='associated_organizations';
    protected $fillable = [

         'title',
        'image',
        'link',

        'created_by',
        'updated_by',
        'sort_order',

        'status',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}
