<?php

namespace Modules\AssociatedOrganization\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\AssociatedOrganization\Entities\AssociatedOrganization;
use Modules\AssociatedOrganization\Repositories\AssociatedOrganizationInterface;

class AssociatedOrganizationController extends Controller
{
    protected $associatedorganization;
    public function __construct(AssociatedOrganizationInterface $associatedorganization){
        $this->associatedorganization=$associatedorganization;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['associatedorganizations'] = $this->associatedorganization->findAll($limit = 50, $filter, $sort);
        $data['associatedorganizations']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('associatedorganization::associatedorganization.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['associatedorganization']=new AssociatedOrganization();
        return view('associatedorganization::associatedorganization.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->associatedorganization->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->associatedorganization->upload($data['logo']);
            // }


            $this->associatedorganization->save($data);
            flash("Associated Organization stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('associatedorganization.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['associatedorganization'] = $this->associatedorganization->find($id);
        return view('associatedorganization::associatedorganization.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['associatedorganization'] = $this->associatedorganization->find($id);
        return view('associatedorganization::associatedorganization.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->associatedorganization->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->associatedorganization->upload($data['logo']);
            // }
            // $data['category_for']="imageinfo";
            $this->associatedorganization->update($id,$data);
            flash("Associated Organization Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('associatedorganization.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->associatedorganization->delete($id);
            flash("Associated Organization  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('associatedorganization.index'));
    }
    }

