<?php
namespace Modules\AssociatedOrganization\Repositories;

use Modules\AssociatedOrganization\Entities\AssociatedOrganization;
use Modules\AssociatedOrganization\Repositories\AssociatedOrganizationInterface;
use Modules\AssociatedOrganization\Repositories\AssociatedOrganizationRepository;


class AssociatedOrganizationRepository implements AssociatedOrganizationInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = AssociatedOrganization::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return AssociatedOrganization::find($id);
    }

   public function getList(){
       $result = AssociatedOrganization::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return AssociatedOrganization::create($data);
    }

    public function update($id,$data){
        $result = AssociatedOrganization::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return AssociatedOrganization::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . AssociatedOrganization::FILE_PATH, $fileName);
        $fileName=AssociatedOrganization::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveAssociatedOrganization()
    {
       return AssociatedOrganization::where('status',1)->get();
    }

}
