@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('csssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
          Associated Organization
            {{-- <a href="{{route('associatedorganization.inactiveindex')}}" class="btn btn-outline-info">Inactive Doctors</a>
            <a href="{{route('associatedorganization.index')}}" class="btn btn-outline-info">Active Doctors</a> --}}
        </th>
        <th class="float-right">
            <a href="{{route('associatedorganization.create')}}" class="btn btn-outline-primary float-right">Add New</a>
        </th>
    </tr>
</table>
@endsection
@section('seccontent')
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(Session::has('success'))
                <div class="alert alert-success">
                    {{ Session::get('success') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger">
                    {{ Session::get('error') }}
                </div>
                @endif
                {{-- <form method="post" method="post" enctype="multipart/form-data" id="myForm"> --}}

                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Title</th>
                            <th>Link</th>




                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($associatedorganizations as $i=>$eachassociatedorganization)
                        <tr id="{{$eachassociatedorganization->id}}">
                            {{-- </form> --}}
                            <td>{{$i+1}}</td>
                            <td>{{$eachassociatedorganization->title}}</td>


                                <td>
                                    {{$eachassociatedorganization->link}}
                                </td>



                            <td>
                                @if($eachassociatedorganization->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>

                            <td>
                                <a href="{{route('associatedorganization.edit', $eachassociatedorganization)}}" class="btn btn-outline-warning"
                                    data-toggle="tooltip" title="Edit Info"><i class="fa fa-edit"> </i></a>
                                <a href="{{route('associatedorganization.show', $eachassociatedorganization->id)}}" data-toggle="tooltip"
                                    title="View Detail" class="btn btn-outline-success"><i class="fa fa-eye"></i></a>
                                <form action="{{route('associatedorganization.destroy', $eachassociatedorganization->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;" id="delete-information-form">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger" data-toggle="tooltip"
                                        title="Delete Information"><i class="fa fa-trash"></i></button>

                                </form>

                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
