<?php

namespace Modules\Banner\Entities;

use App\User;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Banner extends Model
{
    use HasSlug;
    const FILE_PATH='/uploads/banner/';
    protected $table='banners';
    protected $fillable = [
        'title',
        'image',
        'description',
        'short_description',
        'created_by',
        'updated_by',
        'sort_order',
        'link',
        'status','slug',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }




}
