<?php

namespace Modules\Blog\Entities;

use App\User;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;


class Blog extends Model
{
    use HasSlug;
    const FILE_PATH='/uploads/blog/';
    protected $table='blogs';
    protected $fillable = [

         'title',
        'image',
        'slug',
        'meta_title',
        'meta_keyword',
        'meta_description',

        'short_description',
        'description',

        'created_by',
        'updated_by',
        'sort_order',

        'status',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }


    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}
