<?php

namespace Modules\BookingManagement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\BookingManagement\Entities\BookingManagement;
use Modules\BookingManagement\Repositories\BookingManagementInterface;

class BookingManagementController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $bookingmanagement;
    public function __construct(BookingManagementInterface $bookingmanagement){
        $this->bookingmanagement=$bookingmanagement;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['bookingmanagements'] = $this->bookingmanagement->findAll($limit = 50, $filter, $sort);
        $data['bookingmanagements']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('bookingmanagement::bookingmanagement.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['bookingmanagement']=new BookingManagement();
        return view('bookingmanagement::bookingmanagement.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->bookingmanagement->upload($data['image']);
            }


            $this->bookingmanagement->save($data);
            flash("bookingmanagement stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('bookingmanagement.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['bookingmanagement'] = $this->bookingmanagement->find($id);
        return view('bookingmanagement::bookingmanagement.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['bookingmanagement'] = $this->bookingmanagement->find($id);
        return view('bookingmanagement::bookingmanagement.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->bookingmanagement->upload($data['image']);
            }
            $data['category_for']="imageinfo";
            $this->bookingmanagement->update($id,$data);
            flash("Booking  Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('bookingmanagement.index'));

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->bookingmanagement->delete($id);
            flash("Booking   Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('bookingmanagement.index'));

    }
}
