<?php

namespace Modules\Categorymodule\Entities;

use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;

class Categorymodule extends Model
{
    use HasSlug;

    const FILE_PATH = '/uploads/categorymodule/';
    protected $table="categorymodules";

    protected $fillable = [
        'title',
        'slug',
        'image',
        'category_for',
        'parent',
        'status',
        'sort_order',
        'featured',

    ];

    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }
    public function parentcategory()
    {
        return $this->belongsTo(CategoryModule::class, 'parent');
    }
}
