<?php

namespace Modules\Categorymodule\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Contracts\Support\Renderable;
use Modules\Categorymodule\Entities\Categorymodule;
use Modules\Categorymodule\Repositories\CategorymoduleInterface;

class CategorymoduleController extends Controller
{
    protected $categorymodule;

    public function __construct(CategorymoduleInterface $categorymodule)
    {
        $this->categorymodule = $categorymodule;
    }

    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
       $data['categorymodule'] = Categorymodule::orderBy('id', 'desc')->get();
        return view('categorymodule::categorymodule.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
       $data['categorymodule'] = new Categorymodule();
       $data['features'] = Categorymodule::where('parent',null)->where('status',1)->latest()->get();
    //    dd($data);

        return view('categorymodule::categorymodule.create',$data);
        // return view('categorymodule::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {

        $input = $request->all();
        if ($request->has('title')) {
            foreach ($request->title as $key => $item) {
                $input['title']=$item;
                $input['parent']=$request->parent;
                # code...
                $status = Categorymodule::create($input);
            }
        }
        if ($status) {
            Session::flash('success', 'Information Updated successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Update');
        }
        return redirect()->route('categorymodule.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('categorymodule::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['categorymodule']=Categorymodule::find($id);
        $data['features'] = Categorymodule::where('parent',null)->where('status',1)->latest()->get();

        return view('categorymodule::categorymodule.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        // dd($Categorymodule);
        $input = $request->all();
        $categorymodule=Categorymodule::find($id);


        $status =$categorymodule->update($input);
        // dd($status);
        if ($status) {
            Session::flash('success', 'Information Updated successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Update');
        }
        return redirect()->route('categorymodule.index');
    }


    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $categorymodule=Categorymodule::find($id);
        $status =$categorymodule->delete();
        if ($status) {
            Session::flash('success', 'Information deleted successfully.');
        } else {
            Session::flash('error', 'Information cannot be deleted.');
        }
        return redirect()->route('categorymodule.index');
    }

}
