<?php
namespace Modules\Categorymodule\Repositories;

use Modules\Categorymodule\Entities\Categorymodule;
use Modules\Categorymodule\Repositories\CategorymoduleInterface;


class CategorymoduleRepository implements CategorymoduleInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Categorymodule::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Categorymodule::find($id);
    }

   public function getList(){
       $result = Categorymodule::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Categorymodule::create($data);
    }

    public function update($id,$data){
        $result = Categorymodule::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Categorymodule::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Categorymodule::FILE_PATH, $fileName);
        $fileName=Categorymodule::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveBanner()
    {
       return Categorymodule::where('status',1)->get();
    }

}
