@extends('layouts.backmaster')

@section('title', 'ContactPerson')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            ContactPerson
        </th>
        <th class="float-right">
            <a href="{{route('contactperson.index')}}" class="btn btn-primary pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('seccontent')
@if (session('status'))
<div class="alert alert-success">
    {{ session('status') }}
</div>
@endif

<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(!isset($contactperson->id))
                <form method="post" action="{{route('contactperson.store')}}" enctype="multipart/form-data" class="valid_form">
                    <input type="hidden" class="form-control" name="created_by" value="{{Auth::user()->id}}">

                    @else
                    <form method="post" action="{{route('contactperson.update',$contactperson)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">
                        {{-- <input type="hidden" name="_method" value="put"> --}}
                        {{method_field('PUT')}}

                        <input type="hidden" class="form-control" name="updated_by" value="{{Auth::user()->id}}">
                        {{-- <input type="hidden" class="form-control" name="created_by" value="{{$contactperson->created_by}}">
                        --}}
                        @endif
                        {{csrf_field()}}

                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Name:</label>
                                    <input type="text" name="name" class="form-control"
                                        value="{{old('name',$contactperson->name)}}" required>
                                    @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="email">email:</label>
                                    <input type="email" name="email" class="form-control"
                                        value="{{old('email',$contactperson->email)}}" required>
                                    @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="phone">phone:</label>
                                    <input type="tel" name="phone" class="form-control"
                                        value="{{old('phone',$contactperson->phone)}}" required>
                                    @if ($errors->has('phone'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Addess:</label>
                                    <input type="text" name="address" class="form-control"
                                        value="{{old('address',$contactperson->address)}}" required>
                                    @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="fb_link">fb_link:</label>
                                    <input type="text" name="fb_link" class="form-control"
                                        value="{{old('fb_link',$contactperson->fb_link)}}" required>
                                    @if ($errors->has('fb_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fb_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="instagram_link">instagram_link:</label>
                                    <input type="text" name="instagram_link" class="form-control"
                                        value="{{old('instagram_link',$contactperson->instagram_link)}}" required>
                                    @if ($errors->has('instagram_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('instagram_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Citizenship document :</label>
                                    <input type="file" class="form-control" name="citizenship" value="{{$contactperson->citizenship}}">
                                    @if(isset($contactperson->id) && $contactperson->citizenship!=null)
                                        <a href="{{asset($contactperson->citizenship)}}" target="_blank">Previously chosen File</a>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image :</label>
                                    <input type="file" class="form-control dropify" name="image" value=""
                                        data-default-file="{{ ($contactperson->image) ? asset($contactperson->image) : '' }}">
                                    {{-- @if(isset($contactperson->id))
                                        <img src="{{asset('/pressReleaseImage/'.$contactperson->image)}}" height="100" width="150">
                                    @endif --}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-xs-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea type="text" name="detail" class="form-control my-editor"
                                        required>{{old('detail',$contactperson->detail)}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$contactperson->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                        </div>

                        <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-success float-right">Save</button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection
