<?php

namespace Modules\DynamicMenu\Entities;

use Illuminate\Database\Eloquent\Model;
//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class DynamicMenu extends Model
{
    use HasSlug;

    protected $fillable = [
        'title',
        'title_in_language',
        'parent',
        'position',
        'page_id',
        'slug',
        'link',
        'icon',
        // 'category_id',
        // 'news_id',
        'status',
        'extra1',
        'extra2',
        'meta_title',
        'meta_description',
        'created_by',
        'updated_by'
    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

}
