<?php
namespace Modules\DynamicMenu\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Modules\Categorymodule\Entities\Categorymodule;
use Modules\DynamicMenu\Entities\DynamicMenu;
use Modules\PageModule\Entities\PageModule;

class DynamicMenuController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        $parent0 = DynamicMenu::where('parent', '0')->orderBy('position', 'asc')->get();
        $parent1 = DynamicMenu::where('parent', '!=', 0)->orderBy('position', 'asc')->get();
        return view('dynamicmenu::manualindex', compact('parent0', 'parent1'));
        // return view('dynamicmenu::index',compact('parent0','parent1'));
    }
    public function mainindex()
    {

        $parent0 = DynamicMenu::where('parent', '0')->orderBy('position', 'asc')->get();
        $parent1 = DynamicMenu::where('parent', '!=', 0)->orderBy('position', 'asc')->get();
        return view('dynamicmenu::manualindex', compact('parent0', 'parent1'));

        // $dynamicMenu = DynamicMenu::orderBy('parent', 'asc')->orderBy('position', 'asc')->simplePaginate(10);

        // return view('backend.dynamicMenu.mainindex', compact('dynamicMenu'));

    }
    public function changestatusmenu($id)
    {$user = DynamicMenu::find($id);
        // dd($user);

        if ($user->status == 0) {
            $user->status = 1;
        } else {
            $user->status = 0;
        }
        // dd($user);

        $status = $user->update();
        return redirect()->route('dynamicMenu.mainindex');}
    // return redirect('backend/dynamicMenu');
    public function create()
    {
        $dynamic_menu = new DynamicMenu();
        $pages        = PageModule::latest()->where('status', 1)->get();
        $category     = Categorymodule::latest()->where('status', 1)->where('category_for', 'imageInfo')->get();
        // $pages = [];
        $news   = [];
        $parent = DynamicMenu::orderBy('title', 'asc')->get();
        return view('dynamicmenu::create', compact('news', 'category', 'dynamic_menu', 'parent', 'pages'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $input = $request->all();
//        $title = $request->title_in_language;
//        $slug = str_slug($title, '-');
//        $input['slug'] = $slug;

        if ($request->page_id != null || $request->page_id != "") {
            if ($request->page_id != "0") {
                $page_id       = $request->page_id;
                $page          = PageModule::find($page_id);
                $link          = url('pages/' . $page->slug);
                $input['link'] = $link;
                # code...
            }

        }
// if ($request->category_id != null || $request->category_id != "") {
//   if ( $request->category_id != "0") {
//       # code...
//       $category_id = $request->category_id;
//  $category = Categorymodule::find($category_id);
//  $link =url('/' . $category->slug);
//  $input['link'] = $link;
//   }

// }

        $image = '';
        if (! empty($request->file('icon'))) {
            $file = $request->file('icon');
            $path = public_path() . '/dynamic_menu_image';
            $name = uniqid() . '_' . $file->getClientOriginalName();
            $name = str_replace(' ', '_', $name);
            if ($file->move($path, $name)) {
                $image         = $name;
                $input['icon'] = $image;
            }
        }

        $status        = DynamicMenu::create($input);
        $dynamicMenuid = $status['id'];
        return redirect()->route('dynamicMenu.mainindex');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('dynamicmenu::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $dynamic_menu = DynamicMenu::find($id);

        $parent           = DynamicMenu::orderBy('title', 'asc')->orWhereNull('parent')->orWhere('parent', '0')->get();
        $selectedpage     = PageModule::find($dynamic_menu->page_id);
        $selectedcategory = Categorymodule::find($dynamic_menu->category_id);
        //    dd($dynamicMenu->page_id);
        // $selectedpage = [];
        $selectedparent = DynamicMenu::find($dynamic_menu->parent);
        $pages          = PageModule::latest()->get();
        $news           = [];
        $category       = Categorymodule::latest()->where('status', 1)->where('category_for', 'imageInfo')->get();

//        return view('backend.dynamicMenu.create', compact('news', 'category', 'dynamicMenu', 'parent', 'selectednews','selectedpage','pages', 'selectedcategory', 'selectedparent'));

        return view('dynamicmenu::create', compact('news', 'category', 'dynamic_menu', 'parent', 'selectedpage', 'pages', 'selectedcategory', 'selectedparent'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $dynamicMenu   = DynamicMenu::find($id);
        $input         = $request->all();
        $title         = $request->title_in_language;
        $slug          = Str::slug($title, '-');
        $input['slug'] = $slug;

        if ($request->page_id != null || $request->page_id != "") {
            if ($request->page_id != "0") {
                $page_id       = $request->page_id;
                $page          = PageModule::find($page_id);
                $link          = url('pages/' . $page->slug);
                $input['link'] = $link;
                # code...
            }

        }
        //     if ($request->category_id != null || $request->category_id != "") {
        //       if ( $request->category_id != "0") {
        //           # code...
        //           $category_id = $request->category_id;
        //      $category = Categorymodule::find($category_id);
        //      $link =url('/' . $category->slug);
        //      $input['link'] = $link;
        //       }

        //  }

        $image = '';
        if (! empty($request->file('icon'))) {
            $file = $request->file('icon');
            $path = public_path() . '/dynamic_menu_image';
            $name = uniqid() . '_' . $file->getClientOriginalName();
            $name = str_replace(' ', '_', $name);
            if ($file->move($path, $name)) {
                $image         = $name;
                $input['icon'] = $image;
            }
        }

        $status = $dynamicMenu->update($input);

        if ($status) {
            Session::flash('success', 'Information Updated successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Update');
        }
        return redirect()->route('dynamicMenu.mainindex');

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $dynamicMenu = DynamicMenu::find($id);

        $status = $dynamicMenu->delete();
        if ($status) {
            Session::flash('success', 'Information deleted successfully.');
        } else {
            Session::flash('error', 'Information cannot be deleted.');
        }
        return redirect('backend/dynamicMenu');
    }
    public function changepositionold(Request $request)
    {
        $arr      = [];
        $position = $request->input('position');
        $id       = $request->input('id');
        // dd($id);
        $data = DynamicMenu::find($id);
        // dd($data);

        if ($data != null) {

            $data->position = $position;
            $data->update();

        }

        // return $arr;
        //    return ('dynamicMenu');
        return ('mainindex');
    }
    protected function changeposition(Request $request)
    {
        $id       = $request->get('id');
        $position = $request->get('position');
        return $request;
        $data           = DynamicMenu::find($id);
        $data->position = $position;

        $is_success = $data->update();
        $position   = $data->position;

        $msg  = "position changed successfully !!!";
        $code = 200;
        $json = json_encode(['success' => 1, 'msg' => $msg, 'id' => $id, 'code' => $code, 'position' => $position]);

        return $json;

    }

    public function saveList($list, $parent_id = 0)
    {
        foreach ($list as $key => $l) {
            $id = $l['id'];

            $updatedata             = DynamicMenu::find($id);
            $updatedata['position'] = $key + 1;
            $updatedata['parent']   = $parent_id;
            $updatedata->update();

            if (array_key_exists("children", $l)) {
                $this->saveList($l["children"], $l["id"]);
            }

        }
    }
    public function changepositiondata(Request $request)
    {
        $this->saveList($request->list);

    }
}