@extends('layouts.backmaster')

@section('title', 'Dynamic Menu')

@section('content_header')
@stop

@section('csssec')

@stop

@section('jssec')
    <script>
        function obtainnews(sel) {
            var id = sel.value;
            // alert(id);
            $.ajax({
                url: '/getobtainnewsurl',
                data: {
                    'category_id': id
                },
                method: 'get',
                success: function(resp) {
                    // alert(resp);
                    $('#news_id').html(resp);
                    // window.location.href = resp;
                }


            });


        }

        function current() {

            document.getElementById('category_id').style.display = "none";

        }
    </script>
@stop

@section('content')

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-heading padding-bottom">
                    <div class="row" style="padding:10px">
                        <table style="width:100%">
                            <tr>
                                <th class="headtext">
                                    Dynamic Menu
                                </th>
                                <th class=" float-right">
                                    <a href="{{ route('dynamicMenu.index') }}"
                                        class="btn btn-outline-primary float-right">Dynamic Menu
                                        List</a>
                                </th>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="panel-body" style="overflow: auto">
                    @if (!isset($dynamic_menu->id))
                        <form method="post" action="{{ route('dynamicMenu.store') }}" enctype="multipart/form-data"
                            id="valid_form">
                            <input type="hidden" readonly class="form-control" name="created_by"
                                value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('dynamicMenu.update', $dynamic_menu) }}" method="post"
                                enctype="multipart/form-data" id="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                <input type="hidden" class="form-control" name="created_by"
                                    value="{{ $dynamic_menu->created_by }}">
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Menu Title</label>
                                <input type="text" name="title" class="form-control"
                                    value="{{ old('title', $dynamic_menu->title) }}" required>

                            </div>

                        </div>
                        {{-- <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Title </label>
                                    <input type="text" name="title_in_language" class="form-control" required
                                        value="{{old('title_in_language',$dynamic_menu->title_in_language)}}">
                                </div>
                            </div> --}}

                    </div>
                    {{-- <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" name="meta_title" class="form-control"
                                        value="{{$dynamic_menu->meta_title}}">
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Meta Description</label>
                                    <textarea type="text" name="meta_description" class="form-control"
                                        placeholder="Meta Description">{{old('meta_description',$dynamic_menu->meta_description)}}</textarea>
                                </div>
                            </div>
                        </div> --}}
                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Icon</label>
                                <input type="file" name="icon" class="form-control" value="{{ $dynamic_menu->icon }}">
                                @if ($dynamic_menu->icon != '')
                                    <img src="{{ asset('/dynamic_menu_image/' . $dynamic_menu->icon) }}" height="100"
                                        width="100">
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Position</label>
                                {{-- <input type="text" name="link" class="form-control" onchange="current()"
                                        value="{{old('link',$dynamic_menu->link)}}"> --}}
                                <input type="number" name="position" class="form-control" onchange="current()"
                                    value="{{ old('position', $dynamic_menu->position) }}">
                            </div>
                        </div>
                    </div>

                    {{-- <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>When to Publish </label>
                                    <br>
                                    <input type="radio" name="publishtime" onclick="current()"
                                        value="published">Publish Now<br>
                                    <input type="radio" name="publishtime" onclick="later()"
                                        value="later">Publish Later
                                </div>
                            </div> --}}

                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Menu Parent</label>
                                <select name="parent" class="form-control myselect">
                                    <option value="0" selected>This Is Main</option>
                                    {{-- <option value="{{$dynamic_menu->parent}}"
                                        selected>{{$dynamic_menu->parent_id}} --}}
                                    @if (isset($selectedparent))
                                        <option value="{{ $selectedparent->id }}" selected>{{ $selectedparent->title }}
                                        </option>
                                    @endif
                                    {{-- {{$p->title}} --}}
                                    </option>
                                    @foreach ($parent as $p)
                                        <option value="{{ old('id', $p->id) }}">
                                            {{ $p->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Link</label>
                                {{-- <input type="text" name="link" class="form-control" onchange="current()"
                                        value="{{old('link',$dynamic_menu->link)}}"> --}}
                                <input type="text" name="link" class="form-control" onchange="current()"
                                    value="{{ old('link', $dynamic_menu->link) }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Pages</label>
                                <select name="page_id" class="form-control myselect">
                                    <option value="0">No Pages</option>
                                    @if (isset($selectedpage))
                                        <option value="{{ $selectedpage->id }}" selected>{{ $selectedpage->title }}
                                        </option>
                                    @endif
                                    @foreach ($pages as $eachpage)
                                        <option value="{{ old('page_id', $eachpage->id) }}">
                                            {{ $eachpage->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        {{-- <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Menu Category</label>
                                <select name="category_id" class="form-control myselect" required
                                    onchange="obtainnews(this)">
                                    <option value="0">Not Category</option>
                                    @if (isset($selectedcategory))
                                    <option value="{{$selectedcategory->id}}" selected>{{$selectedcategory->title}}
                                    </option>
                                    @endif
                                    @foreach ($category as $eachcategory)
                                    <option value="{{old('category_id',$eachcategory->id)}}">
                                        {{$eachcategory->title}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div> --}}
                    </div>



                    {{-- <div class="row" id="category_id">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Menu Category</label>
                                    <select name="category_id" class="form-control myselect" required
                                        onchange="obtainnews(this)">
                                        <option value=""></option>
                                        @if (isset($selectedcategory))
                                        <option value="{{$selectedcategory->id}}" selected>{{$selectedcategory->title}}
                                        </option>
                                        @endif
                                        @foreach ($category as $eachcategory)
                                        <option value="{{old('category_id',$eachcategory->id)}}">
                                            {{$eachcategory->title}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Menu news</label>
                                    <select class="form-control myselect" name="news_id" id="news_id">
                                        @if (isset($selectednews))
                                        <option value="{{$selectednews->id}}" selected>{{$selectednews->title}}</option>
                                        @endif
                                    </select>

                                </div>
                            </div>
                        </div> --}}

                    <div class="row">

                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status</label>
                                <input type="radio" name="status" id="status" value="1" checked>Active
                                <input type="radio" name="status" id="status" value="0">Inactive
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="extra1">Show In Footer Also</label>
                                <input type="radio" name="extra1" id="extra1" value="1">Yes
                                <input type="radio" name="extra1" id="extra1" value="0" checked>No
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="extra2">Show Only In Footer</label>
                                <input type="radio" name="extra2" id="extra2" value="0" checked>No
                                <input type="radio" name="extra2" id="extra2" value="1">Yes
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <table style="width:100%">
                            <tr>
                                <th> </th>
                                <th class=" float-right">
                                    <button class="btn btn-outline-warning form-control">Submit</button>
                                </th>
                            </tr>
                        </table>

                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>



@stop
