@extends('layouts.backmaster')

@section('title', 'Dynamic Menu')

@section('content_header')

@stop
@section('csssec')
<style>
</style>
@stop

@section('jssec')
<script>
    function changeposition(sel, id) {
        pos = sel.value;
        if (pos == 0) {
            alert(
                "position 0 is default , you cannot assign 0 as position , eg: for nav menu '1' represend just after home,2 represend in second position of navbar etc");
            location.reload();
        } else {
            $.ajax({
                url: '/changeposition',
                data: {
                    'position': pos,
                    'id': id
                },
                method: 'get',
                success: function (resp) {
                    // alert(resp);
                    window.location.href = resp;
                }


            });

        }
        //  alert(id);



    }

</script>

@stop

@section('content')

<div class="row">
    <div
        class="col-md-10 col-lg-10 col-xl-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1 col-xs-offset-0 col-sm-offset-0 col-xl-offset-1">
        <div class="panel panel-default">
            <div class="panel-heading padding-bottom">
                <div class="row">
                    <div class="col-xs-10">
                        <h1>Dynamic Menu</h1>
                    </div>
                    <div class="col-xs-2 padding-top">
                        <a href="{{route('dynamicMenu.create')}}" class="btn btn-outline-primary pull-right">Add Dynamic
                            Menu</a>
                    </div>
                </div>
                {{-- <label>dynamicMenu List</label> --}}
            </div>

            <div class="panel-body" style="overflow: auto">
                @if(Session::has('success'))
                <div class="alert alert-success">
                    {{ Session::get('success') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger">
                    {{ Session::get('error') }}
                </div>
                @endif

                <table class="table table-bordered" id="">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Dynamic Menu Title</th>
                            <th>Parent</th>
                            <th>Position</th>
                            {{-- <th>Link</th> --}}
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($dynamicMenu as $i=>$eachdynamicMenu)
                        <tr>
                            <td>{{$i+1}}</td>
                            <td>{{$eachdynamicMenu->title}}</td>
                            @if ($eachdynamicMenu->parent==null || $eachdynamicMenu->parent==0)
                            <td>Main</td>
                            @else
                            <td>{{App\DynamicMenu::where('id',$eachdynamicMenu->parent)->pluck('title')->first()}}</td>

                            @endif
                            {{-- <td><input type="number" id="position" value="{{$eachdynamicMenu->position}}"
                                    onchange="changeposition(this,'{{$eachdynamicMenu->id}}')"></td> --}}
                                    <td>
                                        {{ {{$eachdynamicMenu->position}} }}
                                    </td>
                            <td>  @if($eachdynamicMenu->status==0)
                                <form action="{{route('changestatusmenu',$eachdynamicMenu->id)}}" method="post">
                                    {{csrf_field()}}

                                    <input type="submit" value="Inactive" class="btn btn-outline-danger">
                                </form>
                                @else
                                <form action="{{route('changestatusmenu',$eachdynamicMenu->id)}}" method="post">
                                    {{csrf_field()}}

                                    <input type="submit" value="Active" class="btn btn-outline-warning">
                                </form>
                                @endif</td>
                            <td>
                                 @if ($eachdynamicMenu->extra1=='0')

                                <a href="{{route('dynamicMenu.edit', $eachdynamicMenu->id)}}" data-toggle="tooltip" title="Edit Information" class="btn btn-outline-primary"><i class="fa fa-edit"> </i></a>
                                <form action="{{route('dynamicMenu.destroy', $eachdynamicMenu->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger" data-toggle="tooltip"
                                        title="Delete Information"><i class="fa fa-trash"></i></button>
                                </form>
                                @else
                                <p>Primary can't edit</p>
                                @endif
                                   <a href="{{route('dynamicMenu.show', $eachdynamicMenu->id)}}" data-toggle="tooltip"
                                    title="View Detail" class="btn btn-outline-warning"><i class="fa fa-eye"></i></a>


                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{$dynamicMenu->links()}}
                {{-- {{ Cookie::get('dynamicMenu_id') }} --}}
            </div>
        </div>
    </div>
</div>
@stop
