<?php
namespace Modules\FAQ\Repositories;

use Modules\FAQ\Entities\FAQ;
use Modules\FAQ\Repositories\FAQInterface;
use Modules\FAQ\Repositories\FAQRepository;


class FAQRepository implements FAQInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = FAQ::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return FAQ::find($id);
    }

   public function getList(){
       $result = FAQ::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return FAQ::create($data);
    }

    public function update($id,$data){
        $result = FAQ::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return FAQ::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . FAQ::FILE_PATH, $fileName);
        $fileName=FAQ::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveFAQ()
    {
       return FAQ::where('status',1)->get();
    }

}
