<?php

namespace Modules\Frontend\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Blog\Entities\Blog;

use Illuminate\Routing\Controller;
use Modules\Banner\Entities\Banner;
use Modules\AboutUs\Entities\AboutUs;
use Modules\OurTeam\Entities\OurTeam;
use Modules\Package\Entities\Package;
use Modules\PageModule\Entities\PageModule;
use Illuminate\Contracts\Support\Renderable;
use Modules\Testimonial\Entities\Testimonial;
use Modules\Frontend\Repositories\FrontendInterface;
use Modules\PackageManagement\Entities\PackageManagement;


class FrontendController extends Controller
{


    protected $frontendInterface;

    public function __construct(

        FrontendInterface $frontendInterface

        )
    {
        $this->frontendInterface = $frontendInterface;

    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        $data['banners']=Banner::latest()->where('status',1)->get();
        $data['aboutus']=AboutUs::first();
        $data['packagemgmts']=PackageManagement::latest()->where('show_home',1)->get();
        $data['featuredpackages']=Package::orderBy('sort_order','asc')->where('is_featured',1)->get();
        $data['blogs']=Blog::orderBy('sort_order','asc')->where('status',1)->get();
        $data['testimonials']=Testimonial::orderBy('sort_order','asc')->where('status',1)->get();

// dd($data['aboutus']);
        return view('frontend::pages.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */

     public function listing($slug)
     {
         $data['packagemanagement']=PackageManagement::where('slug',$slug)->first();
         return view('frontend::pages.listing',$data);
     }
     public function packagedetail($slug)
     {
         $data['package']=Package::where('slug',$slug)->first();

         return view('frontend::pages.package-detail',$data);
     }

     public function aboutus()
     {
        $data['aboutus']=AboutUs::first();
        $data['ourteam']=OurTeam::orderBy('sort_order','asc')->where('status',1)->get();
         return view('frontend::pages.about',$data);
     }

     public function contact()
     {
         return view('frontend::pages.contact');
     }

     public function blogdetail($slug)
     {
        $data['blog']=Blog::where('slug',$slug)->first();
        // dd($data);
         return view('frontend::pages.blog-detail',$data);
     }
     public function pagedetail($slug)
     {
        $data['blog']=PageModule::where('slug',$slug)->first();
        // dd($data);
         return view('frontend::pages.page-detail',$data);
     }
     public function blog()
     {
        $data['blogs']=Blog::latest()->paginate(50);

         return view('frontend::pages.blog',$data);
     }



    public function create()
    {
        return view('frontend::create');
    }

    public function annapurnabasecamptrek()
    {
        return view('frontend::pages.annapurna-base-camp-trek');
    }
    public function annapurnabasecamp()
    {
        return view('frontend::pages.annapurna-base-camp');
    }
    public function annapurnacircuit()
    {
        return view('frontend::pages.annapurna-circuit');
    }
    public function annapurnadhaulagiri()
    {
        return view('frontend::pages.annapurna-dhaulagiri');
    }
    public function annapurnaregion()
    {
        return view('frontend::pages.annapurna-region');
    }
    public function bhutancultural()
    {
        return view('frontend::pages.bhutan-cultural');
    }
    public function bhutanhikingtrekking()
    {
        return view('frontend::pages.bhutan-hiking-trekking');
    }
    public function bhutan()
    {
        return view('frontend::pages.bhutan');
    }
    // public function packagedetail($slug)
    // {
    //     $data['package']=Package::where('slug',$slug)->first();
    //     return view('frontend::pages.detail',$data);
    // }

    public function bungyjump()
    {
        return view('frontend::pages.bungy-jump');
    }
    public function canoeing()
    {
        return view('frontend::pages.canoeing');
    }
    public function chitwannationalpark()
    {
        return view('frontend::pages.chitwan-national-park');
    }
    public function climbingexpedition()
    {
        return view('frontend::pages.climbing-expedition');
    }

    public function daytour()
    {
        return view('frontend::pages.day-tour');
    }
    public function destination()
    {
        return view('frontend::pages.destination');
    }
    public function ebcgokyolake()
    {
        return view('frontend::pages.ebcgokyo-lake');
    }
    public function everestpanaromatrek()
    {
        return view('frontend::pages.everest-panaroma-trek');
    }
    public function everestregion()
    {
        return view('frontend::pages.everest-region');
    }
    public function langtangvalley()
    {
        return view('frontend::pages.langtang-valley');
    }
    public function helambucircuit()
    {
        return view('frontend::pages.helambu-circuit');
    }
    public function helambugosaikunda()
    {
        return view('frontend::pages.helambugosaikunda');
    }
    public function helitourtoannapurnabasecamp()
    {
        return view('frontend::pages.heli-tour-to-annapurna-base-camp');
    }
    public function helitourtoeverestbasecamp()
    {
        return view('frontend::pages.heli-tour-to-everest-base-camp');
    }
    public function everestbasecamp()
    {
        return view('frontend::pages.everest-base-camp');
    }
    public function index2()
    {
        return view('frontend::pages.index2');
    }
    public function junglesafari()
    {
    //    $data['packagemanagement']=PackageManagement::where('slug',$slug)->get();
        return view('frontend::pages.jungle-safari');
    }
    public function kailashmansarovar()
    {
        return view('frontend::pages.kailash-mansarovar');
    }
    public function kailashviasimikot()
    {
        return view('frontend::pages.kailash-via-simikot');
    }
    public function kathmanduworldheritagesitetour()
    {
        return view('frontend::pages.kathmandu-world-heritage-site-tour');
    }
    public function khopratrek()
    {
        return view('frontend::pages.khopra-trek');
    }
    public function langtanggosaikunda()
    {
        return view('frontend::pages.langtang-gosaikunda');
    }

    public function langtangregion()
    {
        return view('frontend::pages.langtang-region');
    }
    public function lhasaviaeverest()
    {
        return view('frontend::pages.lhasa-via-everest');
    }
    public function lifedoorspecialpackage()
    {
        return view('frontend::pages.life-door-special-package');
    }
    public function lowermustang()
    {
        return view('frontend::pages.lower-mustang');
    }
    public function manasluregion()
    {
        return view('frontend::pages.manaslu-region');
    }
    public function manasluround()
    {
        return view('frontend::pages.manaslu-round');
    }
    public function manaslutrek()
    {
        return view('frontend::pages.manaslu-trek');
    }
    public function mardihimal()
    {
        return view('frontend::pages.mardi-himal');
    }
    public function mountainbikingtrek()
    {
        return view('frontend::pages.mountain-biking-trek');
    }
    public function mountainclimbing()
    {
        return view('frontend::pages.mountain-climbing');
    }
    public function mtkailashviasimikot()
    {
        return view('frontend::pages.mt-kailash-via-simikot');
    }
    public function panchase()
    {
        return view('frontend::pages.panchase');
    }
    public function paragliding()
    {
        return view('frontend::pages.paragliding');
    }
    public function poonhill()
    {
        return view('frontend::pages.poon-hill');
    }
    public function rafting()
    {
        return view('frontend::pages.rafting');
    }
    public function restrictedarea()
    {
        return view('frontend::pages.restricted-area');
    }
    public function restricteduppermustang()
    {
        return view('frontend::pages.restricted-upper-mustang');
    }
    public function rimvalleytrek()
    {
        return view('frontend::pages.rim-valley-trek');
    }
    public function rockclimbing()
    {
        return view('frontend::pages.rock-climbing');
    }
    public function shorttrek()
    {
        return view('frontend::pages.short-trek');
    }
    public function tamangheritage()
    {
        return view('frontend::pages.tamang-heritage');
    }
    public function threehighpasses()
    {
        return view('frontend::pages.three-high-passes');
    }
    public function tibet()
    {
        return view('frontend::pages.tibet');
    }
    public function tilichoannapurnacircuit()
    {
        return view('frontend::pages.tilicho-annapurna-circuit');
    }
    public function trekkingandhiking()
    {
        return view('frontend::pages.trekking-and-hiking');
    }
    public function tsumvalley()
    {
        return view('frontend::pages.tsum-valley');
    }
    public function upperdolpo()
    {
        return view('frontend::pages.upper-dolpo');
    }
    public function uppermustang()
    {
        return view('frontend::pages.upper-mustang');
    }
    public function valleycyclingtour()
    {
        return view('frontend::pages.valley-cycling-tour');
    }
    public function yogatrek()
    {
        return view('frontend::pages.yoga-trek');
    }
    public function zipline()
    {
        return view('frontend::pages.zip-line');
    }


    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */

    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('frontend::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('frontend::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
