@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection

@push('metatag')

<meta name="title" content="{{ $siteSetting->meta_title }}">
<meta name="description" content="{{ $siteSetting->meta_description }}" />

<meta property="og:title" content="{{ $siteSetting->meta_title }}" />
<meta property="og:site_name" content="{{ $siteSetting->meta_title }}" />
<meta property="og:url" content="{{ route('frontend.aboutus') }}" />
<meta property="og:description" content="{{ $siteSetting->meta_description }}" />
<meta property="og:type" content="website" />
<meta property="og:image" content="{{ asset($siteSetting->image) }}" />

<meta property="twitter:card" content="summary_large_image" />
<meta property="twitter:title" content="{{ $siteSetting->meta_title }}" />
<meta property="twitter:description" content="{{ $siteSetting->meta_description }}" />



@endpush
@section('content')
    <!-- <body class="page-template page-template-templates page-template-template-about page-template-templatestemplate-about-php page page-id-83">BEGIN WAYBACK TOOLBAR INSERT -->

    <div class="content-wrap clearfix inner about-wrapper">
        <section class="section about-wrap">
            <div class="container">
                <h2>Welcome to {{$siteSetting->title}}</h2>
                <div class="row">
                    <div class="col-sm-8 cont-wrap">
                        {!! $aboutus->description !!} </div>
                    <div class="col-sm-4 image-wrap">
                        <div class="image-hold clearfix">
                            <figure class="photo">
                                <img class="img-responsive" src="{{ asset($aboutus->image) }}" alt="">
                            </figure>
                            <div class="row">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="team-wrap clearfix">
                    <h2>Our Team</h2>
                    <div class="team-hold">
                        <ul class="clearfix row">
                            @foreach ($ourteam as $item)


                            <li class="col-sm-4">
                                <div class="photo-wrap clearfix">
                                    <div class="photo-holder">
                                        <img src="{{ asset($item->image) }}"
                                            class="attachment-full size-full wp-post-image" alt=""
                                            sizes="(max-width: 500px) 100vw, 500px">
                                    </div>
                                    <div class="title-wrap">
                                        <h3>{{ $item->title }}</h3>
                                        <p>{{ $item->post }}</p>
                                    </div>
                                </div>
                                <div class="details-infos clearfix">
                             {{ $item->short_description }}
                                </div>
                                <div class="btn-wrap">
                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                        data-target="#myModal{{ $item->id }}">View More</button>
                                </div>
                                <!-- Modal -->
                                <div class="modal fade" id="myModal{{ $item->id }}" tabindex="-1" aria-labelledby="myModalLabel">
                                    <div class="modal-dialog  modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close"><span aria-hidden="true">×</span></button>
                                                <h4 class="modal-title" id="myModalLabel">{{ $item->title }}</h4>
                                            </div>
                                            <di class="modal-body clearfix">
                                                <div class="photo-holder">
                                                    <img src="{{ asset($item->image) }}"
                                                        class="attachment-full size-full wp-post-image" alt=""
                                                        sizes="(max-width: 500px) 100vw, 500px">
                                                </div>
                                                <p>{!! $item->description !!}</p>
                                            </di>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-primary"
                                                    data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            @endforeach




                            {{-- <li class="col-sm-4">
                                <div class="photo-wrap clearfix">
                                    <div class="photo-holder">
                                        <img src="{{ asset('frontend/image/24171739_10211715353574247_845588751_n1.jpg') }}"
                                        class="attachment-full size-full wp-post-image" alt=""
                                        sizes="(max-width: 360px) 100vw, 360px">
                                    </div>
                                    <div class="title-wrap">
                                        <h3>Binod Silwal.</h3>
                                        <p>Guide/Porter.</p>
                                    </div>
                                </div>
                                <div class="details-infos clearfix">

                                </div>
                                <div class="btn-wrap">
                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                    data-target="#myModal769">View More</button>
                                </div>
                                <!-- Modal -->
                                <div class="modal fade" id="myModal769" tabindex="-1" aria-labelledby="myModalLabel">
                                    <div class="modal-dialog  modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close"><span aria-hidden="true">×</span></button>
                                                <h4 class="modal-title" id="myModalLabel">Binod Silwal.</h4>
                                            </div>
                                            <div class="modal-body clearfix">
                                                <div class="photo-holder">
                                                    <img src="{{ asset('frontend/image/2017/11/24171739_10211715353574247_845588751_n1.jpg') }}"
                                                    class="attachment-full size-full wp-post-image" alt=""
                                                    sizes="(max-width: 360px) 100vw, 360px">
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-primary"
                                                data-dismiss="modal">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li> --}}
                        </ul>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <div class="about-why"
    style="background:url({{ asset($aboutus->why_us_image) }})  right center; background-size:50% 100%;&quot;">
    <div class="bg1 section">
        <div class="container">
            <div class="row">
                <div class="clearfix">
                    <div class="col-sm-6">
                        <div class="heading">
                            <h2>Why us</h2>
                        </div>
                        <div class="whyus-content-wrap clearfix">
                            {!! $aboutus->why_us !!}
                            {{-- <ul class="clearfix">
                                <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>Competitive Price
                                </li>
                                <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>Nepal's leading
                                    Trekking Brand</li>
                                    <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>Experience &amp;
                                        good english speaking license holder guides</li>
                                        <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>90% Recommended
                                            &amp; almost 50% repeated clients</li>
                                            <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>Best
                                                Accommodation,
                                                Healthy Fooding and luxury lodging. </li>
                                                <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>Customers Safety
                                                </li>
                                                <li><span class="icon-wrap"><i class="fa fa-check">&nbsp;</i></span>0% Rescue till
                                                    date
                                                </li>
                                            </ul> --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
@endsection
