@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class=""></li>
                <li data-target="#carousel-example-generic" data-slide-to="1" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="2" class=""></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item">
                    <img src="{{ asset('frontend/image/trekking-the-himalayas-annapurna-base-camp-in-7-days-main-image-900.jpg') }}"
                        alt="abc-tour">
                </div>

                <div class="item active">
                    <img src="{{ asset('frontend/image/Annapurna-Base-Camp-Trek-in-December.jpg') }}" alt="">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/Annapurna-Base-Camp-Weather-September1-1024x540.jpg') }}"
                        alt="">
                </div>

            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
        <h3>Annapurna base Camp</h3>
       </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>12 days</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Pokhara, Kathmandu</span>
                        </li>
                        <!-- <li>
          <strong>Country :</strong>
          <span>Nepal</span>
         </li>
         <li>
          <strong>Price :</strong>
          <span class="price">Rs. </span>
         </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div> <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                        <li>
                            <a href="#testimonials" aria-controls="tab" data-toggle="tab">Testimonials</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>One of the more popular treks of Nepal known for its stunning scenery allows
                                    trekkers with a shorter length of time to witness some of the landscapes and get
                                    in close proximity to the Himalayan peaks as you would on a longer trek. The
                                    trail goes alongside terraced rice paddies, lush rhododendron forests and high
                                    altitude landscapes with the Annapurna Range in view most of the time. It’s
                                    overlooked by the domineering peaks of Annapurna (8091m) and Machapuchare
                                    (6993m), meaning “Fishtail” for its distinctive summit. At the top you will
                                    witness a 360-degree view of some of the highest summits in the world, with a
                                    view like this it’s hard not to feel humbled.</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <p><strong>Day 1:</strong> Drive to Pokhara by bus (6-7 hours). Alt 820m/ 2690ft.
                                </p>
                                <p><strong>Day 2:</strong> Drive to Nayapul (1 hour) then trek to Hile (3 hours).
                                    Alt 1430m/ 4690ft.</p>
                                <p><strong>Day 3:</strong> Trek to Ghorepani&nbsp;(Alt. 2800m/9184ft.) (6 hours).
                                </p>
                                <p style="text-align: left;"><strong>Day 4:</strong> Trek to Poon hill for sunrise
                                    (3200m, 45 mins up and 30 mins down). Then trek to Tadapani (2630m/ 8626ft)(5
                                    and 1/2 hours).</p>
                                <p><strong>Day 5:</strong> Trek to Chhomrung Alt. 2170m/7117ft. Length 5 hours.</p>
                                <p><strong>Day 6:</strong> Trek to Bamboo Alt. 2310m/7576ft. Length 4-5 hours.</p>
                                <p><strong>Day 7:</strong> Trek to Deurali Alt. 3230m/ 10594ft. Length 5 hours.</p>
                                <p style="text-align: left;"><strong>Day 8:</strong> Trek to Machhapuchhre Base Camp
                                    and then to Annapurna Base Camp. Alt 4200m/ 13776ft. Length 5 hours.</p>
                                <p><strong>Day 9:</strong> Trek back to Bamboo. Alt 2310m/ 7576 ft. Length 5 hours.
                                </p>
                                <p><strong>Day 10:</strong> Trek to Jhinu (hot springs). Alt 1780m/ 5838ft. Length 5
                                    hours.</p>
                                <p><strong>Day 11:</strong> Trek to Landruk. Alt 1565m/ 5133ft. Length 4 hours.</p>
                                <p><strong>Day 12:</strong> Trek to Kande (1720m, length 4 hours) then drive back to
                                    Pokhara (1 hour).</p>
                                <p><strong>&nbsp;</strong></p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact
                                                us</a> </em>if any confusion or queries regarding the&nbsp;
                                        Annapurna base camp.</p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Airport Pick up and drop.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Hotel Accommodation in Pokhara with bed and breakfast.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Tea house Accommodation in trekking.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All transportation by flight.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All experienced English speaking government license holder
                                            guide.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Porter (2 trekkers: 1 porter) maximum 20kg.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Insurance / Food / Accommodation for guide &amp; porter.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All paper work and permit, tims card.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>First aid kits.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All government tax.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Food (Breakfast, Lunch, Dinner) in trekking period.</span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Nepal Visa fee.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>International airfair.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Lunch/ Dinner at Pokhara.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Extra days in Kathmandu in case early Arrival departure.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Travel and health Insurance.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Personal Expenses.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Tips</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">
                                <p>Type of
                                    Trek: Tea house</p>
                                <p>Max.
                                    Altitude: 4130 m</p>
                                <p>Grade: Moderate – Strenuous</p>

                                <p>Per Day
                                    Walk: 4-7 hours</p>
                                <p>Best
                                    Season: Feb to June &amp; Sep to Nov</p>
                                <p>
                                    Attraction: Annapurna 1</p>
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;28.5978035&quot;,&quot;longitude&quot;:&quot;83.83765160000007&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;9&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>

                        <div class="tab-pane package-details" id="testimonials">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <h4>Laura L Tz (Germany)</h4>
                                    The Best! super well organized; We had a wonderful time with you, Bal Kumar,
                                    Bhabi; and Dependra! So much Love and greetings from Germany ! Thank you for all
                                    your Help and giving us these fantastic memories!
                                    <hr>
                                    <h4>Clara Lindhard Neltoft (Denmark)</h4>
                                    Me and my friend did the trek to Annapurna basecamp (ABC) in april 2016.
                                    We had very little trekking experience and felt a bit nervous about taking such
                                    a long trek for the very first time.
                                    We met Tashi, who is the owner of the company. He was very friendly and
                                    informative about all the questions we had about which trek to choose and what
                                    to be aware of. Everything was very professional and we instantly felt safe
                                    about booking the trek with his company. We met the guide beforehand and even
                                    got Tashis help buying gear etc. without any extra charges. The trek was
                                    absolutely amazing. Nepal is the most beautiful country in the world and it was
                                    an incredible experience. Our guide was very experienced. When I experienced a
                                    small degree of altitude sickness he quickly knew what to do, gave me medicine
                                    and a specific diet and i felt better instantly. He was very helpful and always
                                    told us what to be aware of and was very aware of us. After coming back to
                                    Kathmandu we met Tashi again because he wanted to make sure, that we were happy
                                    and satisfied with everything.
                                    Furthermore I have been trekking a lot in Nepal since and the prices in Life
                                    Door Treks &amp; Expeditions are very fair and good compared to how professional
                                    and friendly everyone in the company is.
                                    In my opinion, one of the best trekking companies in Nepal, out of so many.
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_248" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="248">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Annapurna base Camp">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
