@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection

@push('metatag')

<meta name="title" content="{{ $siteSetting->meta_title }}">
<meta name="description" content="{{ $siteSetting->meta_description }}" />

<meta property="og:title" content="{{ $siteSetting->meta_title }}" />
<meta property="og:site_name" content="{{ $siteSetting->meta_title }}" />
<meta property="og:url" content="{{ route('frontend.blog') }}" />
<meta property="og:description" content="{{ $siteSetting->meta_description }}" />
<meta property="og:type" content="website" />
<meta property="og:image" content="{{ asset($siteSetting->image) }}" />

<meta property="twitter:card" content="summary_large_image" />
<meta property="twitter:title" content="{{ $siteSetting->meta_title }}" />
<meta property="twitter:description" content="{{ $siteSetting->meta_description }}" />



@endpush

@section('content')



<div class="content-wrap  inner about clearfix">

    <div class="blogs-inner">
        <div class="container">
            <h2>Our Blogs</h2>
            <div class="blog-list-inner">
                <div class="row">
                    @foreach ($blogs as $item)

                    <div class="col-sm-6">
                        <div class="box">
                            <div class="media">
                                <a
                                    href="{{ route('frontend.blogdetail',$item->slug) }}">
                                    <div class="media-left">
                                        <img width="360" height="270"
                                            src="{{ asset($item->image) }}"
                                            class="img-responsive" alt=""
                                            sizes="(max-width: 360px) 100vw, 360px"> </div>
                                    <div class="media-body">
                                        <h4 class="media-heading">{{ $item->title }}</h4>
                                        <span>{{ $item->created_at }}</span>
                                      {{$item->short_description}}
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    {{-- <div class="col-sm-6">
                        <div class="box">
                            <div class="media">
                                <a
                                    href="{{ route('frontend.blogdetail','rwet') }}">
                                    <div class="media-left">
                                        <img width="360" height="270"
                                            src="{{ asset('frontend/image/blog.png') }}"
                                            class="img-responsive" alt=""
                                            sizes="(max-width: 360px) 100vw, 360px"> </div>
                                    <div class="media-body">
                                        <h4 class="media-heading">Test -1</h4>
                                        <span>January 9, 2018</span>
                                        Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque
                                        ante sollicitudin. Cras purus odio, vestibulum in vulputate at, tempus
                                        viverra turpis. Fusce...
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div> --}}
                    @endforeach
                    {{ $blogs->links()}}



                </div>
            </div>
        </div>
    </div>
</div>





@endsection
