@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="1"></li>
                <li data-target="#carousel-example-generic" data-slide-to="2"></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item active">
                    <img src="{{ asset('frontend/image/visit-to-manaslu.jpg') }}" alt="">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/trekking-in-manaslu-region.jpg') }}"
                        alt="trekking-in-manaslu-region">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/scene-of-manaslu-region.jpg') }}" alt="scene-of-manaslu-region">
                </div>

            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
        <h3>Manaslu Trek</h3>
       </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>20 days</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <!-- <li>
          <strong>Country :</strong>
          <span>Nepal</span>
         </li>
         <li>
          <strong>Price :</strong>
          <span class="price">Rs. 20000</span>
         </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div>
    <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                        <li>
                            <a href="#testimonials" aria-controls="tab" data-toggle="tab">Testimonials</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>Mt. Manaslu (8156m) is the world 8th highest mountain in the world and is close to
                                    Annapurna massif. Manaslu round passes by Gurung inhabitants and their cultures,
                                    Marsyangdi River, Manaslu conservation area. The trek also
                                    offers excellent monasteries glimpse. The region is protected by the government, thus,
                                    requires special permission to go through the route.</p>
                                <p>The region is rich in local heritage and biological diversity. The highest point of the
                                    trek “Larkya La Pass” is believed to be the most amazing pass crossing the Himalayas.
                                </p>
                                <p>Tsum valley close to Manaslu range is holy Himalayan pilgrimage valley. The valley is
                                    wealthy in ancient arts, religion, and cultures. Tsum valley is considered as framework
                                    region for gumbas and ringboche which include Mu-gumba.
                                    The region has Tibetan origins with unique dialect. The beautiful landscape has
                                    picturesque attributes. People from this region travel all across to Tibet to buy basic
                                    needs to sustain their lives for a year.</p>
                                <p>The valley was officially recognized as trekking destination in 1992 and now is regard as
                                    finest trekking trails.</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <div id="tab" class="tab-pane package-details active">
                                    <div class="content-details">
                                        <p><strong>Day 1:</strong> Drive to&nbsp; Arughat Alt. 535m/ 1754ft. (5-6 hours)</p>
                                        <p><strong>Day 2:</strong> Trek to Labu Besi Alt. 880m/ 2886ft. (4-5 hours)</p>
                                        <p><strong>Day 3:</strong> Trek to Khola Besi Alt. 970m/ 3181ft. (5 hours)</p>
                                        <p><strong>Day 4:</strong> Trek to Jagat Alt. 1440m/ 4723ft. (6 hours)</p>
                                        <p><strong>Day 5:</strong> Trek to Nyak Alt.&nbsp; 2300m/ 7544ft. (6 hours)</p>
                                        <p><strong>Day 6:</strong> Trek to Ghap Alt. 2110m/ 6920ft. (5 hours)</p>
                                        <p><strong>Day 7:</strong> Trek to Lho Alt. 3180m/ 10430ft. (6 hours)</p>
                                        <p><strong>Day 8:</strong> Trek to Samagaun Alt. 3530m/ 11578ft. (3-4 hours)</p>
                                        <p><strong>Day 9:</strong> Trek to Samdo Alt. 3900m/ 12792t. (3 hours)</p>
                                        <p><strong>Day 10:</strong> Rest day</p>
                                        <p><strong>Day 11:</strong> Trek to Larkya Refuge Alt. 4200m/ 13776ft. (4 hours)</p>
                                        <p><strong>Day 12:</strong> Trek over the Larkya La (5212m)- trek to Bimtang
                                            Alt.3720m/ 12201 ft. (10-12 hours)</p>
                                        <p><strong>Day 13:</strong> Trek to Tilche Alt. 2240m/ 7347ft. (6 hours)</p>
                                        <p><strong>Day 14:</strong> Trek to Chamje Alt. 1430m/ 4690m/ft. ( 5 hours)</p>
                                        <p><strong>Day 15:</strong> Trek to Bhulbule Alt. 840m/ 2755ft. ( 5 hours)</p>
                                        <p><strong>Day 16:</strong> Trek to Besi Sahar Alt. 840m/ 2755ft. (4 hours)</p>
                                        <p><strong>Day 17:</strong> Drive to Kathmandu (6 hours)</p>
                                        <p><strong>Permit fees for</strong> <strong>Manaslu &amp; Tsum valley:</strong> Per
                                            week 90$ per person on other season and 70$ per week per person in spring. and
                                            Manaslu conservation entry fee&nbsp; Rs.2000 each person
                                            and Annapurna conservation Rs.2000 each.<br>
                                            <strong>Note that:</strong> You have to have special trekking permits which are
                                            authorized only for registered trekking agency.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact us</a>
                                        </em>if any confusion or queries regarding the Manaslu Trek.</p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Airport Pick up and drop.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Hotel Accommodation in Kathmandu/Pokhara with bed and breakfast.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Tea house Accommodation in trekking.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All transportation by Road / flight.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All experienced English speaking government license holder guide.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Porter (2 trekkers: 1 porter) maximum 20kg.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Insurance / Food / Accommodation for guide &amp; porter.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All paper work and permit, tims card.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>First aid kits.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All government tax.</span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Nepal Visa fee.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>International airfair.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Lunch/ Dinner at Kathmandu / Pokhara.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Extra days in Kathmandu in case early Arrival departure.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Travel and health Insurance.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Personal Expenses.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Tips.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">

                                <p>Per Day Walk: 4-7 hours</p>
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;28.5497107&quot;,&quot;longitude&quot;:&quot;84.55967680000003&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;12&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>

                        <div class="tab-pane package-details" id="testimonials">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_161" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="161">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Manaslu Trek">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
