@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="1"></li>
                <li data-target="#carousel-example-generic" data-slide-to="2"></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item active">
                    <img src="{{ asset('frontend/image/Mt_Kailash.jpg"') }} alt="Mt_Kailash">
                </div>



            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
        <h3>Mt.Kailash via Simikot</h3>
       </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>20 days</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <!-- <li>
          <strong>Country :</strong>
          <span>China</span>
         </li>
         <li>
          <strong>Price :</strong>
          <span class="price">Rs. </span>
         </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div> <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p style="text-align: left;">Trek to Mt. Kailash via Simikot is adventurous as a
                                    well spiritual expedition. This elevated altitude trek begins from Simikot in
                                    Nepal and settles at the border of Nepal and Tibet. This package heads towards
                                    border at Hilsa and then towards Mt. Kailash and Manasarovar.</p>
                                <p>The tours pass through several magnificent passes like Nara La pass (4530m),
                                    dazzling landscape, mesmerizing natural vegetation, warm and friendly peoples
                                    and villages.</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <p><strong>Day 1:</strong>&nbsp;Pick up from Airport and transfer to hotel.</p>
                                <p><strong>Day 2:</strong>&nbsp;Sightseeing of Kathmandu valley.</p>
                                <p><strong>Day 3:</strong>Fly to Nepalgunj.</p>
                                <p><strong>Day 4:</strong>&nbsp;Early morning fly to Simikot (2,985m) and then trek
                                    to Darapori (2,360m). Overnight at hotel.</p>
                                <p><strong>Day 5</strong><strong>:</strong>&nbsp;Trek to Kermi (2,860m).5 to 6hrs
                                    Overnight at the hotel.</p>
                                <p><strong>Day 6:&nbsp;</strong>Kermi to Yalbang (2,879m/9,445ft): 5 – 6 hours</p>
                                <p><strong>Day 7</strong><strong>:</strong>&nbsp;Yalbang to Tumkot
                                    (3,073m/10,082ft): 5 – 6 hours</p>
                                <p><strong>Day 8:&nbsp;</strong>Tumkot to Yari (3,663m/12,017ft): 6 – 7 hours</p>
                                <p><strong>Day 9:&nbsp;</strong>Yari to Hilsa (3,647m/11,965ft) via Nara La pass: 5
                                    – 6 hours</p>
                                <p><strong>Day 10</strong><strong>:</strong>&nbsp;Hilsa to Purang (3,772m/12,375ft):
                                    2 – 3 hours</p>
                                <p><strong>Day 11:&nbsp;</strong>Purang to Montser (4,450m/14,599ft) and sightseeing
                                    in Tirtapuri: 3 – 4 hours</p>
                                <p><strong>Day 12</strong><strong>:</strong>&nbsp;Sightseeing of Garuda Valley, then
                                    transfer to Darchen (4,560m/14,956ft): 3 – 4 hours</p>
                                <p><strong>Day 13</strong><strong>:</strong>&nbsp;First day of Kora: hiking to Dira
                                    Puk Monasterys (5120m/16,792ft), 5 – 6 hours</p>
                                <p><strong>Day 14</strong><strong>:</strong>&nbsp;Second day of Kora: hike to
                                    Dzutul-puk (4790m/15,765ft): 18km, 6 – 7 hours</p>
                                <p><strong>Day 15:&nbsp;</strong>Third day of Kora: hiking to Darchen
                                    (4,560m/15,000ft): 14km, 3 – 4 hours and transfer to Manasarovar</p>
                                <p><strong>Day 16</strong><strong>:</strong>&nbsp;Tour of the Mansarovar Lake</p>
                                <p><strong>Day 17</strong><strong>:</strong>&nbsp;Mansarovar to Saga
                                    (4,600m/15,088ft) 495 km, 8 – 9 hours</p>
                                <p><strong>Day 18</strong><strong>:</strong>&nbsp;Saga to Zhangmu (3,750m/12,300ft)
                                    325km, 4 – 5 hours</p>
                                <p><strong>Day 19</strong><strong>:</strong>&nbsp;Zhangmu to Kathmandu: 153km, 4 – 5
                                    hours</p>
                                <p><strong>Day 20:</strong>&nbsp;Final Departure</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact
                                                us</a> </em>if any confusion or queries regarding the Mt. Kailash
                                        via Simikot.</p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span> Twin sharing accommodation as per the itinerary on BB basis (Bed and
                                            Breakfast)</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>English speaking Tibetan Guide</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span> Transportation as per the itinerary by Van</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Entry fee of mention places</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Tibet Travel permit</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span> Tibet Visa Fee</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span> Airfare KATHMANDU – LHASA – KATHMANDU</span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span> Travel Insurance</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Lunch and Dinner in hotel or a restaurant</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span> Drinks beverages (hard and soft drinks)</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span> Expenses of personal nature, phone calls, laundry etc</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span> Gratuity to staff</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Services not mentioned here in new messages</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">
                                <p>Type of
                                    Trek: Group Tour</p>
                                <p>Max.
                                    Altitude: 5250m</p>
                                <p>Grade: Easy to moderate</p>

                                <p>Per Day Walk: 4-8 hours</p>
                                <p>Best
                                    Season: April-June, August-November</p>
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;29.647535&quot;,&quot;longitude&quot;:&quot;91.117525&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;12&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!-- /.destination -->
        <section class="section book-form clearfix"
            style="background: url('image/image08.jpg') no-repeat center center;
  background-size: cover;">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_209" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="209">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}
                            "
                                width="40" alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Mt.Kailash via Simikot">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
