@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection

@push('metatag')
    <meta name="title" content="{{ $package->meta_title }}">
    <meta name="description" content="{{ $package->meta_description }}" />

    <meta property="og:title" content="{{ $package->meta_title }}" />
    <meta property="og:site_name" content="{{ $package->meta_title }}" />
    <meta property="og:url" content="{{ route('frontend.packagedetail', $package->slug) }}" />
    <meta property="og:description" content="{{ $package->meta_description }}" />
    <meta property="og:type" content="website" />
    <meta property="og:image" content="{{ asset($package->image) }}" />

    <meta property="twitter:card" content="summary_large_image" />
    <meta property="twitter:title" content="{{ $package->meta_title }}" />
    <meta property="twitter:description" content="{{ $package->meta_description }}" />
@endpush

@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class=""></li>
                <li data-target="#carousel-example-generic" data-slide-to="1" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="2"></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                @foreach ($package->packagegallery as $i => $item)
                    <div class="item {{ $i == 0 ? 'active' : '' }}">
                        <img src="{{ asset($item->image) }}" alt="naturally-beautiful-annapurna">
                    </div>
                @endforeach

                {{-- <div class="item active">
                <img src="{{ asset('frontend/image/Kopra_-Annapurna-region_-Himalaya_-Nepal-392767-1920px-16x7.jpg') }}" alt="">
            </div>

            <div class="item">

                <img src="{{ asset('frontend/image/187807_d34b78b9.jpg') }}" alt="">
            </div> --}}

            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
            <h3>Annapurna / Dhaulagiri</h3>
           </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>{{ $package->duration }}</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>{{ $package->starting_point }}</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>{{ $package->ending_point }}</span>
                        </li>
                        <!-- <li>
              <strong>Country :</strong>
              <span>Kathmandu</span>
             </li>
             <li>
              <strong>Price :</strong>
              <span class="price">Rs. </span>
             </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div> <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                        <li>
                            <a href="#testimonialid" aria-controls="tab" data-toggle="tab">Testimonial</a>
                        </li>
                        <li>
                            <a href="#testimonials" aria-controls="tab" data-toggle="tab">Tour Guide</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>{!! $package->description !!}</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                {!! $package->itinerary !!}
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    {!! $package->includes !!}
                                    {{-- <p>Please write or <em><a
                                            href="mailto:info@sarathiholidays.com.np">contact
                                            us</a> </em>if any confusion or queries regarding the&nbsp;
                                    Annapurna/Dhaulagiri.</p>
                                <h4>Cost Includes</h4>
                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>Airport Pick up and drop.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>Hotel Accommodation in Pokhara with bed and breakfast.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>Tea house Accommodation in trekking.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>All transportation by flight.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>All experienced English speaking government license holder
                                        guide.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>Porter (2 trekkers: 1 porter) maximum 20kg.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>Insurance / Food / Accommodation for guide &amp; porter.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>All paper work and permit, tims card.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>First aid kits.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>All government tax.</span>
                                </div>


                                <div class="hold clearfix">
                                    <i class="fa fa-check-square"></i>
                                    <span>Food (Breakfast, Lunch, Dinner) in trekking period.</span>
                                </div> --}}


                                </div>
                                {{-- <div class="exclude-wrapper clearfix">
                                <h4>Cost Excludes</h4>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>Nepal Visa fee.</span>
                                </div>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>International airfair.</span>
                                </div>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>Lunch/ Dinner at Pokhara.</span>
                                </div>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>Extra days in Kathmandu in case early Arrival departure.</span>
                                </div>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>Travel and health Insurance.</span>
                                </div>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>Personal Expenses.</span>
                                </div>
                                <div class="hold clearfix">
                                    <i class="fa fa-close"></i>
                                    <span>Tips.</span>
                                </div>
                            </div> --}}
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">
                                {!! $package->fact !!}
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                {!! $package->map !!}
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="testimonialid">
                            <div class="content-details">
                                {!! $package->testimonial !!}
                            </div>
                        </div>

                        <div class="tab-pane package-details" id="testimonials">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    @foreach ($package->packageGuide as $guide)
                                        <img src="{{ $guide->image }}" alt="" height="50" width="50">
                                        <br>
                                        <b>{{ $guide->title }}
                                        </b> <br>
                                        <p>{{ $guide->short_description }}
                                        </p> <br>

                                        <p>{!! $guide->description !!}
                                        </p>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center" style="color:#a32f2f">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">

                    <form action="{{ route('inquiry.store') }}" method="post" id="tourBooking_257"
                        class="bookingDetail">
                        @csrf
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="name"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">Phone</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Phone Number"
                                        name="phone" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="257">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Annapurna / Dhaulagiri">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
