@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="1" class=""></li>
                <li data-target="#carousel-example-generic" data-slide-to="2"></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item active">
                    <img src="{{ asset('frontend/image/manaslu-circuit-trek-1575375110318.jpg') }}" alt="">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/109912_829a60f0.jpg') }}" alt="view-of-manaslu-region">
                </div>


            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
            <h3>Manaslu and Tsum Valley</h3>
           </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>24 days</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <!-- <li>
              <strong>Country :</strong>
              <span>Nepal</span>
             </li>
             <li>
              <strong>Price :</strong>
              <span class="price">Rs. </span>
             </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div> <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                        <li>
                            <a href="#testimonials" aria-controls="tab" data-toggle="tab">Testimonials</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>Tsum valley close to Manaslu range is holy Himalayan pilgrimage valley. The
                                    valley is wealthy in ancient arts, religion, and cultures. Tsum valley is
                                    considered as framework region for gumbas and ringboche which include Mu-gumba.
                                    The region has Tibetan origins with unique dialect. The beautiful landscape has
                                    picturesque attributes. People from this region travel all across to Tibet to
                                    buy basic needs to sustain their lives for a year.</p>
                                <p>The valley was officially recognized as trekking destination in 1992 and now is
                                    regard as finest trekking trails.</p>
                                <p style="text-align: left;">
                                </p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <p><strong>Day&nbsp; 01:&nbsp;</strong> Driving from Kathmandu to Arughat (535m-10
                                    hours by bus)<br>
                                    <strong>Day&nbsp; 02:</strong>&nbsp; Trek from Arughat to
                                    Liding&nbsp;(860m-7km-4 hours walk)<br>
                                    <strong>Day&nbsp; 03:</strong>&nbsp; Trek to Machhakhola (930m-9km-5 hours
                                    walk)<br>
                                    <strong>Day&nbsp; 04:</strong>&nbsp; Trek to Dobhan (1410m-6 hours walk)<br>
                                    <strong>Day&nbsp; 05:</strong>&nbsp; Trek to Philim (2040m-5.5 hours walk)<br>
                                    <strong>Day&nbsp; 06:</strong>&nbsp; Trek to Chumling (2363m-3.5 hours walk)<br>
                                    <strong>Day&nbsp; 07:</strong>&nbsp; Trek to Chhokangparo (3010m-8 hours
                                    walk)<br>
                                    <strong>Day&nbsp; 08:</strong>&nbsp; Rest day at Chhokangparo (3361m-5 hours
                                    walk-around)<br>
                                    <strong>Day&nbsp; 09:</strong>&nbsp; Trek to Nile&nbsp;(3700m-3 hours walk)<br>
                                    <strong>Day&nbsp; 10:&nbsp;</strong> Trek to Bhajyo (Chhekya) ( 3240m-4.5 hours
                                    walk)<br>
                                    <strong>Day&nbsp; 11:&nbsp;</strong> Rest day at Bhajyo (Chhekya) ( 2400m-7
                                    hours walk)<br>
                                    <strong>Day&nbsp; 12:</strong>&nbsp; Trek to Ra Chhen Gompa(3200m-4 hours
                                    walk)<br>
                                    <strong>Day&nbsp; 13:</strong>&nbsp; Trek to Chumje&nbsp;(2468m-5 hours
                                    walk)<br>
                                    <strong>Day&nbsp; 14:&nbsp;</strong> Trek to Bihi (1990m-7 hours walk)<br>
                                    <strong>Day&nbsp; 15:&nbsp;</strong> Trek to Namrung (2660m-7 hours walk)<br>
                                    <strong>Day&nbsp; 16:&nbsp;</strong> Trek to Lho (3180m-6 hours walk)<br>
                                    <strong>Day&nbsp; 17:</strong>&nbsp; Trek to Samagaun (3525m- 5 hours walk)<br>
                                    <strong>Day&nbsp; 18:</strong>&nbsp; Trek to Samdo(3860m-5 hours walk)<br>
                                    <strong>Day&nbsp; 19:</strong>&nbsp; Trek to High Camp(4460m-5 hours walk)<br>
                                    <strong>Day&nbsp; 20:&nbsp;</strong> Trek to Bimtang(3930m-7 hours walk)<br>
                                    <strong>Day&nbsp; 21:</strong>&nbsp; Trek to Dharapani(1920m-8 hours walk)<br>
                                    <strong>Day&nbsp; 22:&nbsp;</strong> Trek to Ghermu(1100m-7 hours walk)<br>
                                    <strong>Day&nbsp; 23:</strong> Trek to Beshisahar(760m-8 hours walk)<br>
                                    <strong>Day&nbsp; 24:</strong>&nbsp; Drive to Kathmandu(1300m-6 hours by bus)
                                </p>
                                <p><strong>Permit fees for</strong> <strong>Manaslu &amp; Tsum valley:</strong> Per
                                    week 90$ per person on other season and 70$ per week per person in spring, and
                                    Manaslu conservation entry fee&nbsp; Rs.2000 per individual and Annapurna
                                    conservation Rs.2000 per each.<br>
                                    <strong>Note that:</strong>Only special trekking permits authorizes for
                                    registered trekking agency to trek in the region.
                                </p>
                                <p>&nbsp;</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact
                                                us</a> </em>if any confusion or queries regarding the Tsum valley.
                                    </p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Airport Pick up and drop.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Hotel Accommodation in Kathmandu with bed and breakfast.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Tea house Accommodation in trekking.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All transportation by Road.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All experienced English speaking government license holder
                                            guide.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Porter (2 trekkers: 1 porter) maximum 20kg.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Insurance / Food / Accommodation for guide &amp; porter.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All paper work and permit, tims card.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>First aid kits.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All government tax.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Food (Breakfast, Lunch, Dinner) in trekking period.</span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Nepal Visa fee.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>International airfair.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Lunch/ Dinner at Kathmandu.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Extra days in Kathmandu in case early Arrival departure.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Travel and health Insurance.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Personal Expenses.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Tips.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">
                                <p>Type of
                                    Trek: Tea house</p>
                                <p>Max.
                                    Altitude: 5212 m</p>
                                <p>Grade: Moderate-Difficult</p>

                                <p>Per Day
                                    Walk: 3 to 1o hours</p>
                                <p>Best
                                    Season: March till May and September till November</p>
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;28.5099817&quot;,&quot;longitude&quot;:&quot;84.96094640000001&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;14&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>

                        <div class="tab-pane package-details" id="testimonials">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <h4>Adam Eckworth (UK)</h4>
                                    We did the Manaslu circuit and Tsum Valley with {{ $siteSetting->title }} and it was
                                    fantastic! Everyone from Tashi, our guide Bhabi and our porter Dipindra were
                                    great and made it such a pleasurable experience when booking the trek and whilst
                                    we were on it for 20 days. I would highly recommend these guys and if back in
                                    Nepal would definitely organise another trek with them! Thanks
                                    {{ $siteSetting->title }}!
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_324" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="324">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Manaslu and Tsum Valley">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
