<?php

namespace Modules\Frontsetting\Models;

use App\User;
use Illuminate\Database\Eloquent\Model;


class Frontsetting extends Model
{
    const FILE_PATH= 'uploads/frontsetting';
    protected $table = 'frontsettings';

    protected $fillable = [
        'name',
        'office_time',
        'blog_text',
        'logo',
        'fav_logo',
        'testimonial_text',
        'news_text',
        'team_text',
        'short_description',
        'mobile1',
        'mobile2',
        'email1',
        'email2',
        'address',
        'whyus_text',
        'sort_order',
        'status',
        'created_by',
        'updated_by',
        'fb_link',
        'twitter_link',
        'youtube_link',
        'tiktok_link',
        'instagram_link',
        'linkedin_link',
        'how_we_work_text',
        'recommendedsite_text',
        'featuredin_text',
        'image'

    ];

  public function createdBy(){
    return $this->belongsTo(User::class,'created_by');
  }
  public function updatedBy(){
    return $this->belongsTo(User::class,'updated_by');
  }
}
