@extends('layouts.master')
@section('content')
    <!-- breadcrumb start -->
    <div class="referal_title authentication-bg position-relative">
        <div class="page_name">
            Front Setting
        </div>
        <nav aria-label="breadcrumb" class="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>

                <li class="breadcrumb-item active" aria-current="page">Front Setting</li>
            </ol>
        </nav>

    </div>
    <!-- breadcrumb end -->

    <div class="below_breadcrumb_devide">
        <a href="{{ route('frontsetting.index') }}">

            <div class="add_new">

                <img src="{{ asset('newpanel/icons/goback-btn.png') }}" alt="">
                <p> List </p>
            </div>
        </a>

    </div>

    <!--------------------------------------- Add New table_section_start --------------------------->
    <div class="add_new_cake">
        @if (!isset($frontsetting->id))
            <form method="post" action="{{ route('frontsetting.store') }}" enctype="multipart/form-data"
                class="valid_form">
                <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
            @else
                <form method="post" action="{{ route('frontsetting.update', $frontsetting) }}" method="post"
                    enctype="multipart/form-data" class="valid_form">
                    {{-- <input type="hidden" name="_method" value="put"> --}}
                    {{ method_field('PUT') }}

                    <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                    {{-- <input type="hidden" class="form-control" name="created_by" value="{{$frontsetting->created_by}}">
                --}}
        @endif
        {{ csrf_field() }}
        <div class="col-xl-8 col-lg-12 mx-auto">
            <div class="row">
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="name">Name:</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name', $frontsetting->name) }}"
                        required>
                    @if ($errors->has('name'))
                        <span class="help-block">
                            <strong>{{ $errors->first('name') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="office_time">Office Time:</label>
                    <input type="text" name="office_time" class="form-control"
                        value="{{ old('office_time', $frontsetting->office_time) }}" required>
                    @if ($errors->has('office_time'))
                        <span class="help-block">
                            <strong>{{ $errors->first('office_time') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="short_description">Short Description:</label>
                    <input type="text" name="short_description" class="form-control"
                        value="{{ old('short_description', $frontsetting->short_description) }}" required>
                    @if ($errors->has('short_description'))
                        <span class="help-block">
                            <strong>{{ $errors->first('short_description') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-12 col-lg-12 col-md-12">
                    <label>Blog Text</label>
                    <textarea type="text" name="blog_text" class="form-control my-editor" required>{{ old('blog_text', $frontsetting->blog_text) }}</textarea>
                </div>
                <div class="mb-5 col-xl-12 col-lg-12 col-md-12">
                    <label>Testimonial Text</label>
                    <textarea type="text" name="testimonial_text" class="form-control my-editor" required>{{ old('testimonial_text', $frontsetting->testimonial_text) }}</textarea>


                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>News Text</label>
                    <textarea type="text" name="news_text" class="form-control " required>{{ old('news_text', $frontsetting->news_text) }}</textarea>
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>How We Work Text</label>
                    <textarea type="text" name="how_we_work_text" class="form-control " required>{{ old('how_we_work_text', $frontsetting->how_we_work_text) }}</textarea>

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label> Why Us Text</label>
                    <textarea type="text" name="whyus_text" class="form-control " required>{{ old('whyus_text', $frontsetting->whyus_text) }}</textarea>

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="mobile1">Mobile 1:</label>
                    <input type="text" name="mobile1" class="form-control"
                        value="{{ old('mobile1', $frontsetting->mobile1) }}" required>
                    @if ($errors->has('mobile1'))
                        <span class="help-block">
                            <strong>{{ $errors->first('mobile1') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="mobile2">Mobile 2:</label>
                    <input type="text" name="mobile2" class="form-control"
                        value="{{ old('mobile2', $frontsetting->mobile2) }}" required>
                    @if ($errors->has('mobile2'))
                        <span class="help-block">
                            <strong>{{ $errors->first('mobile2') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="address">Address:</label>
                    <input type="text" name="address" class="form-control"
                        value="{{ old('address', $frontsetting->address) }}" required>
                    @if ($errors->has('address'))
                        <span class="help-block">
                            <strong>{{ $errors->first('address') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="email1">Email 1:</label>
                    <input type="email" name="email1" class="form-control"
                        value="{{ old('email1', $frontsetting->email1) }}" required>
                    @if ($errors->has('email1'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email1') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="email2">Email 2:</label>
                    <input type="email" name="email2" class="form-control"
                        value="{{ old('email2', $frontsetting->email2) }}" required>
                    @if ($errors->has('email2'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email2') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>Logo :</label>
                    <input type="file" class="form-control dropify" name="logo" value=""
                        data-default-file="{{ $frontsetting->logo ? asset($frontsetting->logo) : '' }}">

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>Fav Logo :</label>
                    <input type="file" class="form-control dropify" name="fav_logo" value=""
                        data-default-file="{{ $frontsetting->fav_logo ? asset($frontsetting->fav_logo) : '' }}">

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>Recommended Site Text</label>
                    <textarea type="text" name="recommendedsite_text" class="form-control " required>{{ old('recommendedsite_text', $frontsetting->recommendedsite_text) }}</textarea>

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>Team Text</label>
                    <textarea type="text" name="team_text" class="form-control " required>{{ old('team_text', $frontsetting->team_text) }}</textarea>

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label>Featuredin Text</label>
                    <textarea type="text" name="featuredin_text" class="form-control " required>{{ old('featuredin_text', $frontsetting->featuredin_text) }}</textarea>

                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="fb_link">Fb Link:</label>
                    <input type="text" name="fb_link" class="form-control"
                        value="{{ old('fb_link', $frontsetting->fb_link) }}" required>
                    @if ($errors->has('fb_link'))
                        <span class="help-block">
                            <strong>{{ $errors->first('fb_link') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="twitter_link">Twitter Link:</label>
                    <input type="text" name="twitter_link" class="form-control"
                        value="{{ old('twitter_link', $frontsetting->twitter_link) }}" required>
                    @if ($errors->has('twitter_link'))
                        <span class="help-block">
                            <strong>{{ $errors->first('twitter_link') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="youtube_link">Youtube Link:</label>
                    <input type="text" name="youtube_link" class="form-control"
                        value="{{ old('youtube_link', $frontsetting->youtube_link) }}" required>
                    @if ($errors->has('youtube_link'))
                        <span class="help-block">
                            <strong>{{ $errors->first('youtube_link') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="instagram_link">Instagram Link:</label>
                    <input type="text" name="instagram_link" class="form-control"
                        value="{{ old('instagram_link', $frontsetting->instagram_link) }}" required>
                    @if ($errors->has('instagram_link'))
                        <span class="help-block">
                            <strong>{{ $errors->first('instagram_link') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="linkedin_link">Linkedin Link:</label>
                    <input type="text" name="linkedin_link" class="form-control"
                        value="{{ old('linkedin_link', $frontsetting->linkedin_link) }}" required>
                    @if ($errors->has('linkedin_link'))
                        <span class="help-block">
                            <strong>{{ $errors->first('linkedin_link') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="sort_order">Sort Order:</label>
                    <input type="text" name="sort_order" class="form-control"
                        value="{{ old('sort_order', $frontsetting->sort_order) }}" required>
                    @if ($errors->has('sort_order'))
                        <span class="help-block">
                            <strong>{{ $errors->first('sort_order') }}</strong>
                        </span>
                    @endif
                </div>






                {{-- <div class="mb-5 col-xl-6 col-lg-6 col-md-6">
                    <label for="Status" class="form-label">Status</label>
                    <br />

                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" name="status" id="status" value="1" checked>
                        <label class="form-check-label" for="Active">Active</label>
                    </div>
                    <div class="form-check form-check-inline">

                            <input type="radio"  class="form-check-input" name="status" id="status" value="0"
                            {{ $frontsetting->status == '0' ? 'checked' : '' }}>
                        <label class="form-check-label" for="Inactive">Inactive</label>
                    </div>
                </div> --}}

                {{-- <div class="mb-5 col-md-12">
                    <label for="description" class="form-label">Item Description</label>
                    <textarea class="form-control" name="description" rows="8" placeholder="Enter"></textarea>
                </div> --}}
            </div>
            <div class="save">
                <button type="submit" class="btn save_item">Save</button>

                {{-- <a href="cake-management-detail.php" type="button" class="btn save_item">Save Item</a> --}}
            </div>
        </div>
        </form>
    </div>


    {{-- new panel --}}



    <!---------------------------------------Add New table_section_start --------------------------->
@endsection
