@extends('layouts.master')
@section('title','Frontsetting')

@section('csssec')

@stop
@section('jssec')
@stop

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
<li class="breadcrumb-item"><a href="{{route('frontsetting.index')}}">list</a></li>
<li class="breadcrumb-item active">Create</li>
@endsection

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Front Setting
        </th>
        <th class="float-right">
            <a href="{{route('frontsetting.index')}}" class="btn btn-info uniform_use_button pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('content')


<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="card-body">
                @if(!isset($frontsetting->id))
                <form method="post" action="{{route('frontsetting.store')}}" enctype="multipart/form-data" class="valid_form">
                    <input type="hidden" class="form-control" name="created_by" value="{{Auth::user()->id}}">

                    @else
                    <form method="post" action="{{route('frontsetting.update',$frontsetting->id)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">

                        {{method_field('PUT')}}

                        <input type="hidden" class="form-control" name="updated_by" value="{{Auth::user()->id}}">


                        @endif
                        {{csrf_field()}}

                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="name">Name:</label>
                                    <input type="text" name="name" class="form-control"
                                        value="{{old('name',$frontsetting->name)}}" required>
                                    @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="office_time">Office Time:</label>
                                    <input type="text" name="office_time" class="form-control"
                                        value="{{old('office_time',$frontsetting->office_time)}}" required>
                                    @if ($errors->has('office_time'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('office_time') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="short_description">Short Description:</label>
                                    <input type="text" name="short_description" class="form-control"
                                        value="{{old('short_description',$frontsetting->short_description)}}" required>
                                    @if ($errors->has('short_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('short_description') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Blog Text</label>
                                    <textarea type="text" name="blog_text" class="form-control my-editor"
                                        required>{{old('blog_text',$frontsetting->blog_text)}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                        <label>Testimonial Text</label>
                                        <textarea type="text" name="testimonial_text" class="form-control my-editor"
                                            required>{{old('testimonial_text',$frontsetting->testimonial_text)}}</textarea>
                                    </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>News Text</label>
                                    <textarea type="text" name="news_text" class="form-control my-editor"
                                        required>{{old('news_text',$frontsetting->news_text)}}</textarea>
                                </div>
                        </div>

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>How We Work Text</label>
                                    <textarea type="text" name="how_we_work_text" class="form-control my-editor"
                                        required>{{old('how_we_work_text',$frontsetting->how_we_work_text)}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label> Why Us Text</label>
                                    <textarea type="text" name="whyus_text" class="form-control my-editor"
                                        required>{{old('whyus_text',$frontsetting->whyus_text)}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="mobile1">Mobile 1:</label>
                                    <input type="text" name="mobile1" class="form-control"
                                        value="{{old('mobile1',$frontsetting->mobile1)}}" required>
                                    @if ($errors->has('mobile1'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mobile1') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="mobile2">Mobile 2:</label>
                                    <input type="text" name="mobile2" class="form-control"
                                        value="{{old('mobile2',$frontsetting->mobile2)}}" required>
                                    @if ($errors->has('mobile2'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mobile2') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="address">Address:</label>
                                    <input type="text" name="address" class="form-control"
                                        value="{{old('address',$frontsetting->address)}}" required>
                                    @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="email1">Email 1:</label>
                                    <input type="email" name="email1" class="form-control"
                                        value="{{old('email1',$frontsetting->email1)}}" required>
                                    @if ($errors->has('email1'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email1') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="email2">Email 2:</label>
                                    <input type="email" name="email2" class="form-control"
                                        value="{{old('email2',$frontsetting->email2)}}" required>
                                    @if ($errors->has('email2'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email2') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Logo :</label>
                                    <input type="file" class="form-control dropify" name="logo" value=""
                                        data-default-file="{{ ($frontsetting->logo) ? asset($frontsetting->logo) : '' }}">

                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Fav Logo :</label>
                                    <input type="file" class="form-control dropify" name="fav_logo" value=""
                                        data-default-file="{{ ($frontsetting->fav_logo) ? asset($frontsetting->fav_logo) : '' }}">

                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Recommended Site Text</label>
                                    <textarea type="text" name="recommendedsite_text" class="form-control my-editor"
                                        required>{{old('recommendedsite_text',$frontsetting->recommendedsite_text)}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Team Text</label>
                                    <textarea type="text" name="team_text" class="form-control my-editor"
                                        required>{{old('team_text',$frontsetting->team_text)}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Featuredin Text</label>
                                    <textarea type="text" name="featuredin_text" class="form-control my-editor"
                                        required>{{old('featuredin_text',$frontsetting->featuredin_text)}}</textarea>
                                </div>
                            </div>
                            {{-- <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image :</label>
                                    <input type="file" class="form-control dropify" name="image" value=""
                                        data-default-file="{{ ($frontsetting->image) ? asset($frontsetting->image) : '' }}">

                                </div>
                            </div> --}}

                        </div>
                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="fb_link">Fb Link:</label>
                                    <input type="text" name="fb_link" class="form-control"
                                        value="{{old('fb_link',$frontsetting->fb_link)}}" required>
                                    @if ($errors->has('fb_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fb_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="twitter_link">Twitter Link:</label>
                                    <input type="text" name="twitter_link" class="form-control"
                                        value="{{old('twitter_link',$frontsetting->twitter_link)}}" required>
                                    @if ($errors->has('twitter_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('twitter_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="youtube_link">Youtube Link:</label>
                                    <input type="text" name="youtube_link" class="form-control"
                                        value="{{old('youtube_link',$frontsetting->youtube_link)}}" required>
                                    @if ($errors->has('youtube_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('youtube_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="instagram_link">Instagram Link:</label>
                                    <input type="text" name="instagram_link" class="form-control"
                                        value="{{old('instagram_link',$frontsetting->instagram_link)}}" required>
                                    @if ($errors->has('instagram_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('instagram_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="linkedin_link">Linkedin Link:</label>
                                    <input type="text" name="linkedin_link" class="form-control"
                                        value="{{old('linkedin_link',$frontsetting->linkedin_link)}}" required>
                                    @if ($errors->has('linkedin_link'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('linkedin_link') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="sort_order">Sort Order:</label>
                                    <input type="text" name="sort_order" class="form-control"
                                        value="{{old('sort_order',$frontsetting->sort_order)}}" required>
                                    @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>



                        </div>

                        {{-- <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$frontsetting->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                        </div> --}}

                        <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-success float-right">Save</button>
                            </div>
                        </div>
                        <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Featuredin Text</label>
                                        <textarea type="text" name="featuredin_text" class="form-control my-editor"
                                            required>{{old('featuredin_text',$frontsetting->featuredin_text)}}</textarea>
                                    </div>
                                </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection

