@extends('layouts.master')

@section('title', 'About us List')

@section('csssec')
@stop
@section('jssec')

@endsection


@section('content')


    <!-- breadcrumb start -->
    <div class="referal_title">
        <div class="page_name">
            Front Setting
        </div>


        <nav aria-label="breadcrumb" class="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Front Setting Management</a></li>

                <li class="breadcrumb-item active" aria-current="page">Front Setting </li>
            </ol>
        </nav>

    </div>
    <!-- breadcrumb start -->

    <div class="below_breadcrumb_devide">
        <div class="dropdown">
            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                data-bs-toggle="dropdown" aria-expanded="false">
                Bulk Action
            </a>

            <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                <li>
                    <a href="javascript:;" class="dropdown-item removeAll" onclick="multioperation('delete')">Delete</a>
                </li>
                <li>
                    <a href="javascript:;" class="dropdown-item removeAll" onclick="multioperation('active')">Activate</a>
                </li>
                <li>
                    <a href="javascript:;" class="dropdown-item removeAll" onclick="multioperation('inactive')">Deactivate</a>
                </li>

            </ul>
        </div>
        {{-- <div class="search-container">
            <span class="search-icon"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                    viewBox="0 0 20 20" fill="none">
                    <path
                        d="M15.5451 14.6626L17.9864 17.1026C18.1002 17.2205 18.1632 17.3784 18.1618 17.5422C18.1603 17.7061 18.0946 17.8629 17.9787 17.9787C17.8629 18.0946 17.7061 18.1603 17.5422 18.1618C17.3784 18.1632 17.2205 18.1002 17.1026 17.9864L14.6614 15.5451C13.0661 16.9119 11.0034 17.6077 8.90612 17.4865C6.80887 17.3652 4.8401 16.4364 3.41291 14.8949C1.98573 13.3534 1.21108 11.319 1.25151 9.21863C1.29194 7.11827 2.14431 5.11521 3.62976 3.62976C5.11521 2.14431 7.11827 1.29194 9.21863 1.25151C11.319 1.21108 13.3534 1.98573 14.8949 3.41291C16.4364 4.8401 17.3652 6.80887 17.4865 8.90612C17.6077 11.0034 16.9119 13.0661 15.5451 14.6614V14.6626ZM9.3751 16.2501C11.1985 16.2501 12.9471 15.5258 14.2365 14.2365C15.5258 12.9471 16.2501 11.1985 16.2501 9.3751C16.2501 7.55174 15.5258 5.80305 14.2365 4.51374C12.9471 3.22443 11.1985 2.5001 9.3751 2.5001C7.55174 2.5001 5.80305 3.22443 4.51374 4.51374C3.22443 5.80305 2.5001 7.55174 2.5001 9.3751C2.5001 11.1985 3.22443 12.9471 4.51374 14.2365C5.80305 15.5258 7.55174 16.2501 9.3751 16.2501Z"
                        fill="#5D5D5D" />
                </svg></span>
            <input type="text" class="search-input" placeholder="Search...">

        </div> --}}

        <div class="right_upload">

            <a type="button" href="{{ route('frontsetting.create') }}" class="upload_btn">Add New About us </a>
        </div>
    </div>

    <!--------------------------------------- table_section_start --------------------------->
    <div class="table-responsive">
        @include('layouts.partials.error')

        <table class="table"  id="datatableinactive">
            <thead>
                <tr>
                    <th>S.N. <input type="checkbox" id="checkboxesMain"></th>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Sort Order</th>

                    {{-- <th>Status</th> --}}
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($frontsettings as $i=>$eachfrontsetting)
                <tr id="{{$eachfrontsetting->id}}">
                    {{-- </form> --}}
                    <td>{{$i+1}}<input type="checkbox" class="checkbox" data-id="{{ $eachfrontsetting->id }}"></td>
                    <td>{{$eachfrontsetting->name}}</td>


                    <td>{{$eachfrontsetting->mobile1}}</td>
                    <td>{{$eachfrontsetting->email1}}</td>
                    <td>{{$eachfrontsetting->sort_order}}</td>

                    {{-- <td>
                        @if($eachfrontsetting->status==1)
                        <label class="badge badge-success">Active</label>
                        @else
                        <label class="badge badge-danger">Inactive</label>
                        @endif
                    </td> --}}

                    <td>

                        <ul class="trash_view">
                            <li>
                                <a href="{{route('frontsetting.edit', $eachfrontsetting)}}"
                                data-toggle="tooltip" title="Edit Info">
                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.20605 2.89569C7.73499 4.78252 9.2113 6.25883 11.106 6.79566M8.09815 2.00359L1.87714 8.2246C1.6403 8.46144 1.40346 8.92723 1.35609 9.2667L1.01662 11.643C0.890304 12.5035 1.49819 13.1035 2.35871 12.9851L4.73501 12.6456C5.06659 12.5983 5.53238 12.3614 5.77711 12.1246L11.9981 5.90357C13.0718 4.82989 13.5771 3.58253 11.9981 2.00359C10.4192 0.424659 9.17182 0.929918 8.09815 2.00359Z" stroke="#880505" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                            </a>
                            </li>
                            <li>
                                <a href="{{route('frontsetting.show', $eachfrontsetting->id)}}" data-toggle="tooltip"
                                    title="View Detail">
                                    <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.00022 9.88657C6.40688 9.88657 5.11355 8.59324 5.11355 6.99991C5.11355 5.40657 6.40688 4.11324 8.00022 4.11324C9.59355 4.11324 10.8869 5.40657 10.8869 6.99991C10.8869 8.59324 9.59355 9.88657 8.00022 9.88657ZM8.00022 5.11324C6.96022 5.11324 6.11355 5.95991 6.11355 6.99991C6.11355 8.03991 6.96022 8.88657 8.00022 8.88657C9.04021 8.88657 9.88688 8.03991 9.88688 6.99991C9.88688 5.95991 9.04021 5.11324 8.00022 5.11324Z" fill="#880505"/>
                                        <path d="M8.00022 13.0132C5.49355 13.0132 3.12688 11.5466 1.50021 8.99991C0.793548 7.89991 0.793548 6.10657 1.50021 4.99991C3.13355 2.45324 5.50022 0.986572 8.00022 0.986572C10.5002 0.986572 12.8669 2.45324 14.4935 4.99991C15.2002 6.09991 15.2002 7.89324 14.4935 8.99991C12.8669 11.5466 10.5002 13.0132 8.00022 13.0132ZM8.00022 1.98657C5.84688 1.98657 3.78688 3.27991 2.34688 5.53991C1.84688 6.31991 1.84688 7.6799 2.34688 8.45991C3.78688 10.7199 5.84688 12.0132 8.00022 12.0132C10.1535 12.0132 12.2135 10.7199 13.6535 8.45991C14.1535 7.6799 14.1535 6.31991 13.6535 5.53991C12.2135 3.27991 10.1535 1.98657 8.00022 1.98657Z" fill="#880505"/>
                                        </svg>
                                </a>
                            </li>
                            <li>

                                <form
                                action="{{route('frontsetting.destroy', $eachfrontsetting->id)}}"
                                method="POST" style="display: inline;"
                                id="delete-aboutus-data{{ $eachfrontsetting->id }}">
                                <input type="hidden" name="_method" value="delete">
                                {{ csrf_field() }}

                                <a type="button" href='javascript:;'
                                    class="reject delete_information_post"
                                    link="delete-aboutus-data{{ $eachfrontsetting->id }}"
                                    data-bs-toggle="modal"
                                    data-bs-target="#modal_project_delete_post">
                                    <svg width="14" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13 3.98659C10.78 3.76659 8.54667 3.65325 6.32 3.65325C5 3.65325 3.68 3.71992 2.36 3.85325L1 3.98659M4.66667 3.31325L4.81333 2.43992C4.92 1.80659 5 1.33325 6.12667 1.33325H7.87333C9 1.33325 9.08667 1.83325 9.18667 2.44659L9.33333 3.31325M11.5667 6.09325L11.1333 12.8066C11.06 13.8533 11 14.6666 9.14 14.6666H4.86C3 14.6666 2.94 13.8533 2.86667 12.8066L2.43333 6.09325M5.88667 10.9999H8.10667M5.33333 8.33325H8.66667" stroke="#880505" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                </a>

                            </form>


                            </li>







                </td>


                </tr>
                @endforeach
            </tbody>
        </table>




        {{ $frontsettings->links() }}
    </div>
    {{-- @if ($aboutuss->count()>0)

    <div class="pagination_main">
        <div class="hint-text">Showing <b>

                {{ $aboutuss->total() > $aboutuss->perPage() ? $aboutuss->perPage() * ($aboutuss->currentPage() - 1) + $aboutuss->count() : $aboutuss->total() }}</b>
            out of <b>
                {{ $aboutuss->total() }}</b> entries</div>

        <ul class="pagination">
            {{ $aboutuss->links() }}
        </ul>
    </div>
    @endif --}}
@endsection

@section('js')
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkboxesMain').on('click', function(e) {
            if ($(this).is(':checked', true)) {
                $(".checkbox").prop('checked', true);
            } else {
                $(".checkbox").prop('checked', false);
            }
        });
        $('.checkbox').on('click', function() {
            if ($('.checkbox:checked').length == $('.checkbox').length) {
                $('#checkboxesMain').prop('checked', true);
            } else {
                $('#checkboxesMain').prop('checked', false);
            }
        });
        });

        function multioperation(val) {
            console.log(val);
            btnvalue=val;

        // }
        // $('.removeAll').on('click', function(e) {
            var studentIdArr = [];
            $(".checkbox:checked").each(function() {
                studentIdArr.push($(this).attr('data-id'));
            });
            // if ($realtimepurchases->transaction_status == 1) {

            if (studentIdArr.length <= 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Choose min one item to remove.',
                    showDenyButton: false,
                    showCancelButton: false,
                    //   confirmButtonText: 'Yes'
                })
                // alert("Choose min one item to remove.");
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Are you sure you want to delete selected record(s)?',
                    showDenyButton: false,
                    showCancelButton: true,
                    confirmButtonText: 'Yes'
                }).then((result) => {
                    // console.log(result.isConfirmed);


                    if (result.isConfirmed == true) {
                        var stuId = studentIdArr.join(",");

                        $.ajax({
                            url: "{{ route('frontsetting.removeMulti') }}",
                            type: 'post',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                    'content')
                            },
                            // type: 'DELETE',
                            // headers: {
                            //     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            // },
                            data: {
                                "_token": "{{ csrf_token() }}",
                                // _token: $csrf_token,
                                "ids": stuId,
                                "btnvalue": btnvalue,
                            },
                            success: function(data) {
                                // console.log(data['should_hide']);
                                if (data['status'] == true) {
                                    location.reload();
                                    // if (data['should_hide'] == true) {

                                    //     $(".checkbox:checked").each(function() {
                                    //         $(this).parents("tr").remove();
                                    //     });
                                    // }

                                    // Swal.fire({
                                    //     icon: 'success',
                                    //     title: data['message'],
                                    //     showDenyButton: false,
                                    //     showCancelButton: false,


                                    // })
                                } else {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Error occured.',
                                        showDenyButton: false,
                                        showCancelButton: false,
                                        //   confirmButtonText: 'Yes'
                                    })
                                    // alert('Error occured.');
                                }
                            },
                            error: function(data) {
                                Swal.fire({
                                    icon: 'success',
                                    title: data.responseText,
                                    showDenyButton: false,
                                    showCancelButton: false,
                                    //   confirmButtonText: 'Yes'
                                })
                                // alert(data.responseText);
                            }
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Deletion process cancelled',
                            showDenyButton: false,
                            showCancelButton: false,
                            //   confirmButtonText: 'Yes'
                        }).then((result) => {
                            $('#checkboxesMain').prop('checked', false);
                            $(".checkbox").prop('checked', false);
                        })
                    }
                });
            }

            // }
            // else(studentIdArr.length <= 0) {
            //         Swal.fire({
            //             icon: 'error',
            //             title: 'Choosed data is already accepted',
            //             showDenyButton: false,
            //             showCancelButton: false,
            //             //   confirmButtonText: 'Yes'
            //         })
            // }
        // });
            }
    // });

    function disableButton() {
            // Disable the button

            // Change the button text
            document.getElementById("submitBtn").innerHTML = "Uploading...";
            document.getElementById("submitBtn").submit();
            document.getElementById("submitBtn").disabled = true;


        }
</script>
@endsection
