@extends('layouts.master')

@section('title', 'Front Setting')

@section('csssec')
@stop

@section('jssec')
@stop

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
<li class="breadcrumb-item"><a href="{{route('frontsetting.index')}}">create</a></li>
<li class="breadcrumb-item active">Show</li>
@endsection

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Front Setting
        </th>
        <th class="float-right">
            <a href="{{route('frontsetting.index')}}" class="btn btn-info uniform_use_button pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-heading">
                    {{-- <a href="{{route('frontsetting.index')}}" class="btn btn-primary pull-right"> List</a> --}}
                    <h4>Detail Page</h4>

                </div>

                <div class="panel-body">
                    <table class="table table-bordered ">
                        <tr>
                            <th>Name</th>
                            <td>{{$frontsetting->name}}</td>
                        </tr>
                        <tr>
                            <th>Address</th>
                            <td>{{$frontsetting->address}}</td>
                        </tr>
                        <tr>
                            <th>Mobile 1</th>
                            <td>{{$frontsetting->mobile1}}</td>
                        </tr>
                        <tr>
                            <th>Mobile 2</th>
                            <td>{{$frontsetting->mobile2}}</td>
                        </tr>
                        <tr>
                            <th>Email 1</th>
                            <td>{{$frontsetting->email1}}</td>
                        </tr>
                        <tr>
                            <th>Email 2</th>
                            <td>{{$frontsetting->email2}}</td>
                        </tr>
                        <tr>
                            <th>Short Description</th>
                            <td>{!! $frontsetting->short_description!!}</td>
                        </tr>
                        <tr>
                            <th>Sort Order</th>
                            <td>{{$frontsetting->sort_order}}</td>
                        </tr>

                        <tr>
                            <th>Logo</th>
                            <td>
                                <img src="{{asset($frontsetting->logo)}}" height="100" width="150">
                            </td>
                        </tr>
                        <tr>
                            <th>Image</th>
                            <td>
                                <img src="{{asset($frontsetting->image)}}" height="100" width="150">
                            </td>
                        </tr>
                        <tr>
                            <th>Fav Logo</th>
                            <td>
                                <img src="{{asset($frontsetting->fav_logo)}}" height="100" width="150">
                            </td>
                        </tr>

                        <tr>
                            <th>Blog Text</th>
                            <td>{!! $frontsetting->blog_text !!}</td>
                        </tr>
                        <tr>
                            <th>Team Text</th>
                            <td>{!! $frontsetting->team_text !!}</td>
                        </tr>
                        <tr>
                            <th>Testimonial Text</th>
                            <td>{!! $frontsetting->testimonial_text !!}</td>
                        </tr>
                        <tr>
                            <th>News Text</th>
                            <td>{!! $frontsetting->news_text !!}</td>
                        </tr>
                        <tr>
                            <th>Whyus Text</th>
                            <td>{!! $frontsetting->whyus_text !!}</td>
                        </tr>
                        <tr>
                            <th>How We Work Text</th>
                            <td>{!! $frontsetting->how_we_work_text !!}</td>
                        </tr>
                        <tr>
                            <th>Recommended Site Text</th>
                            <td>{!! $frontsetting->recommendedsite_text !!}</td>
                        </tr>
                        <tr>
                            <th>Featuredin Text</th>
                            <td>{!! $frontsetting->featuredin_text !!}</td>
                        </tr>
                        <tr>
                            <th>How We Work Text</th>
                            <td>{!! $frontsetting->how_we_work_text !!}</td>
                        </tr>
                        <tr>
                            <th>Facebook Link</th>
                            <td>{{$frontsetting->fb_link}}</td>
                        </tr>
                        <tr>
                            <th>Twitter Link</th>
                            <td>{{$frontsetting->twitter_link}}</td>
                        </tr>
                        <tr>
                            <th>Instagram Link</th>
                            <td>{{$frontsetting->instagram_link}}</td>
                        </tr>
                        <tr>
                            <th>Linkedin Link</th>
                            <td>{{$frontsetting->linkedin_link}}</td>
                        </tr>
                        <tr>
                            <th>Youtube Link</th>
                            <td>{{$frontsetting->youtube_link}}</td>
                        </tr>

                        <tr>
                            <td>
                                <a href="{{route('frontsetting.edit', $frontsetting)}}" class="btn btn-info uniform_use_button"><i
                                        class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                            </td>
                            <td>
                                <form action="{{route('frontsetting.destroy', $frontsetting->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn uniform_use_button btn-danger"><i
                                            class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>

                                </form>

                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
