<?php

namespace Modules\GeneralUser\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use App\Models\User;
use App\Rules\ReCaptcha;
use Laracasts\Flash\Flash;
use Illuminate\Support\Str;
use App\Mail\UserVerifyMail;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Contracts\Support\Renderable;
use Modules\GeneralUser\Models\GeneralUser;
use Modules\GeneralUser\Models\VerifyEmail;
class AuthRegisterController extends Controller
{
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => [ 'string', 'email', 'max:255', 'unique:generalusers'],
            'mobile' => [ 'integer','required', 'digits:10'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'g-recaptcha-response' => ['required', new ReCaptcha]
        ],[
            'required' => 'The :attribute field is required.',
            'confirmed' => 'The :attribute Should be matched.',
        ]
    );
    }

    public function showRegisterForm()
    {
        // $data['is_admin']=0;
        $data['user_time']=User::first();
        // dd($data);

        return view('generaluser::auth.register',$data);
    }
    public function showadminRegisterForm()
    {
        $data['is_admin']=1;
        $data['user_time']=User::first();

        return view('generaluser::auth.register',$data);
    }

    protected function storeGeneralUser(Request $request)
    {
        $this->validator($request->all())->validate();
        $input = $request->all();
        // $input['password']=$request->password_reg;
        // $input['email']=$request->email;
        // $input['user_type'] = Customer::userType()['customer'];
        $input['status'] = 1;

        try {
            // dd($input);
            // $generaluser=GeneralUser::create([
            //     'name' => $request->name,
            //     'email' => $request->email,
            //     // 'password' => Hash::make($request->password),
            //     'password' => $request->password,
            //     'status' => 1
            // ]);
            // dd($input);
            $generaluser = GeneralUser::create($input);
            $generaluser->generaluserProfile()->create($input);
            // dd($generaluser->id);
            $verifyUser = VerifyEmail::create([
                'generaluser_id' => $generaluser->id,
                'verification_token' => Str::random(32)
            ]);
            // send verification mail

            Mail::to($generaluser->email)->send(new UserVerifyMail($generaluser));


        } catch (\Throwable $t) {
            Flash::error($t->getMessage());
        }

        // Flash::success("User Created  successfully");
        Session::flash('success', 'Your are successfully registered,Please check mail to Verify your account');

        return redirect('/generaluserlogin');
    }

}
