<?php

namespace Modules\GeneralUser\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;


use Carbon\Carbon;
use GuzzleHttp\Client;
use App\Mail\VerifyMail;
use Laracasts\Flash\Flash;
use Illuminate\Support\Str;
use App\Mail\UserVerifyMail;
use App\Mail\ResetPasswordMail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use App\ServiceContainer\BackendService;
use Modules\AclManagement\Models\Role;
use Illuminate\Support\Facades\Validator;
use Illuminate\Contracts\Support\Renderable;
use Modules\GeneralUser\Models\GeneralUser;
use Modules\GeneralUser\Models\VerifyEmail;
use Modules\GeneralUser\Models\GeneralUserProfile;
use Modules\GeneralUser\Repositories\GeneralUserInterface;


class GeneralUserController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $generalUserInterface;
    public function __construct( GeneralUserInterface $generalUserInterface)
    {
        $this->generalUserInterface = $generalUserInterface;
    }
    public function index()
    {
        // dd("FDAS");
        $data['generalusers'] = GeneralUser::orderBy('id', 'desc')->get();
        $data['role']=Role::all();
        return view('generaluser::generaluser.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['generaluser']=new GeneralUser();
        return view('generaluser::generaluser.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */

     protected function validatorstore(array $data)
     {
         return Validator::make($data, [
             'name' => ['required', 'string', 'max:255'],
             'email' => [ 'nullable','string', 'email', 'max:255', 'unique:generalusers'],
             'mobile' => [ 'integer','required', 'digits:10'],
            //  'password' => ['required', 'string', 'min:8'],
         ],[
             'required' => 'The :attribute field is required.',
            //  'confirmed' => 'The :attribute Should be matched.',
         ]
     );
     }
    protected function store(Request $request)
    {
        $this->validatorstore($request->all())->validate();
        $input = $request->all();
        $input['password']=$request->mobile;
        // $input['email']=$request->email;
        // $input['user_type'] = Customer::userType()['customer'];
        $input['status'] = 1;

        try {
            // dd($input);
            // $generaluser=GeneralUser::create([
            //     'name' => $request->name,
            //     'email' => $request->email,
            //     // 'password' => Hash::make($request->password),
            //     'password' => $request->password,
            //     'status' => 1
            // ]);
            // dd($input);
            $generaluser = GeneralUser::create($input);
            $generaluser->generaluserProfile()->create($input);
            // dd($generaluser->id);
            $verifyUser = VerifyEmail::create([
                'generaluser_id' => $generaluser->id,
                'verification_token' => Str::random(32)
            ]);
            // send verification mail
            if ($generaluser->email!=null) {
                # code...
                Mail::to($generaluser->email)->send(new UserVerifyMail($generaluser));
            }



        } catch (\Throwable $t) {
            Flash::error($t->getMessage());
        }

        // Flash::success("User Created  successfully");
        Session::flash('success', 'Your are successfully registered,Please check mail to Verify your account');

        return redirect()->route('generaluser.index');

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function generaluserprofile($id)
    {
        $data['user'] = GeneralUser::find($id);
        // dd($data);
        if (auth()->check()) {

            return view('generaluser::generaluser.generaluserprofilebyadmin',$data);
            # code...
        }
        return view('generaluser::generaluser.generaluserprofile',$data);
    }
    public function show($id)
    {


        $data['generaluser'] = Auth::guard('generaluser')->user();
        return view('generaluser::generaluser.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['generaluser'] = GeneralUser::find($id);
        // $data['generaluser'] = Auth::guard('generaluser')->user();
        // $data['province']=NepalDivision::distinct('province')->pluck('province');

        return view('generaluser::generaluser.edit', $data);
    }
    public function myedit()
    {
        $data['generaluser'] = Auth::guard('generaluser')->user();
        // $data['province']=NepalDivision::distinct('province')->pluck('province');

        return view('generaluser::generaluser.myedit', $data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function myupdate(Request $request, $id)
    {
        // dd($id);
        $generaluser=Auth::guard('generaluser')->user();
        $input = $request->all();
        if($request->hasFile('profile_image')){
            $path = GeneralUser::IMAGE_PATH;
            $input['profile_image']=BackendService::upload($input['profile_image'],$path);
        }
        // dd($input);

        $status =$generaluser->update($input);

        if ($status) {
            $generaluserprofile=GeneralUserProfile::where('generaluser_id',$generaluser->id)->first();
            if($generaluserprofile){
                $generaluserprofile->update($input);

            }
            else {

                $input['generaluser_id'] = $generaluser->id;
                GeneralUserProfile::create($input);
            }
            Session::flash('success', 'Information Updated successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Update');
        }
        return redirect()->route('generaluser.generaluserprofile', $generaluser->id);
    }

    public function update(Request $request, $id)
    {
        // dd($id);
        $generaluser=GeneralUser::find($id);
        $request->validate(
            [

            'name' => ['required', 'string', 'max:255'],
            'email' => 'required|email|unique:generalusers,email,'.$generaluser->id,
            'mobile' => 'required|unique:generalusers,mobile,'.$generaluser->id,
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        $input = $request->all();
        if($request->hasFile('profile_image')){
            $path = GeneralUser::IMAGE_PATH;
            $input['profile_image']=BackendService::upload($input['profile_image'],$path);
        }
        // dd($input);

        $status =$generaluser->update($input);

        if ($status) {
            $generaluserprofile=GeneralUserProfile::where('generaluser_id',$generaluser->id)->first();
            if($generaluserprofile){
                $generaluserprofile->update($input);

            }
            else {

                $input['generaluser_id'] = $generaluser->id;
                GeneralUserProfile::create($input);
            }
            Session::flash('success', 'Information Updated successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Update');
        }
        return redirect()->route('generaluser.index');
        // return redirect()->route('generaluser.generaluserprofile', $generaluser->id);
    }


    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }



    public function changePassword()
    {
        return view('generaluser::auth.change-password');
    }
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'old_password' => 'required',
            'password'=>'required|min:6|confirmed',
            'password_confirmation'=>'sometimes|min:6|required_with:password'
        ]);
    }
    public function changePasswordStore(Request $request)
    {
        // $request->validate( [
        //     'old_password' => 'required',
        //     'password'=>'required|min:6|confirmed',
        //     'password_confirmation'=>'sometimes|min:6|required_with:password'
        // ]);
        $this->validator($request->all())->validate();

        $oldPassword = $request->get('old_password');
        $newPassword = $request->get('password');

        $id = auth()->guard('generaluser')->user()->id;
        $users = auth()->guard('generaluser')->user()->find($id);

        try {

            if (!(Hash::check($oldPassword, $users->password))) {
                flash("Old Password Incorrect !!!")->error();
                          return redirect()->back();

            } else {

                $data['password'] = $newPassword;
                $users->update($data);

                flash("Password Updated !!!")->success();

            }
        } catch (\Throwable $t) {
            flash($t->getMessage())->error();
            // flash("Something went wrong at our side")->error();
        }

        return redirect('/');
    }

    // reset password

    public function forgetPassword()
    {
        return view('generaluser::auth.forget-password');
    }


    public function forgetPasswordPost(Request $request)
    {
        $all = $request->all();
        // dd($all);

        try {
            $generaluserdata = GeneralUser::where('email',$all['email'])->first();
            // dd($generaluserdata);
            if ($generaluserdata)
            {
                // $generaluser = ResetPassword::create($data);
                //Create Password Reset Token
                $generaluser=DB::table('password_resets')->insert([
                    'email' => $request->email,
                    'token' => Str::random(60),
                    'created_at' => Carbon::now()
                ]);
                // dd($generaluser);
                $generaluser = DB::table('password_resets')
                ->where('email', $request->email)->first();

                // dd($generaluser);
                Mail::to($generaluser->email)->send(new ResetPasswordMail($generaluser));
                // Mail::send('mail.reset-password', ['generaluser' => $generaluser], function ($mail) use ($generaluser) {
                //     $mail->from('info@raramart.com', 'Rara Mart');
                //     $mail->to($generaluser->email)->subject('Reset Password');
                // });
                Flash::success("Reset link has been sent to your email. Please check to reset password.");
            }
            else{
                // dd("fasd");
                Flash::error("Please Provide correct mailing address !!");
                return redirect()->back();
            }

        } catch (\Throwable $t) {
            Flash::error($t->getMessage());
            return redirect()->back();

        }

        return redirect(route('generaluserlogin'));

    }

    public function resetPassword($token)
    {
        // dd("fsdf");
        session(['resetPassToken' => $token]);
        $resetUser = DB::table('password_resets')
        ->where('token', $token)->latest()->first();
        // dd($resetUser);
        // $resetUser = ResetPassword::where('token', $token)->first();

        if (!isset($resetUser)) {
            flash('Token is expired,Resend email to generate Token')->error();
            return redirect(route('forget.password'));
        }
        $email=$resetUser->email;
        return view('generaluser::auth.reset-password',compact('email','token'));

        // return view('generaluser::auth.reset-password');
    }

    public function resetPasswordStore(Request $request)
    {

        $all = $request->all();
        $resetPassToken = session('resetPassToken');
        $validatedData = $request->validate([
            'password' => 'required|confirmed|min:6',
        ]);
        // $resetUser = ResetPassword::where('token', $resetPassToken)->first();
        $resetUser = DB::table('password_resets')
        ->where('token', $resetPassToken)->latest()->first();
        $generaluser = GeneralUser::where('email',$resetUser->email)->first();
        if ($generaluser) {
            $generaluser->password = $all['password'];
            $generaluser->save();
            //Release resetPassword Token
            session()->forget('resetPassToken');
            Flash::success("Password changed successfully. You may now login with new password");
            DB::table('password_resets')->where('token', $resetPassToken)->latest()->delete();
            return redirect()->route('generaluserlogin');
        } else {
            Flash::error("Sorry Something went wrongg !!! Please Try Again");

            return redirect()->back();

        }

    }

    public function verifyUser($token)
    {
        $verifyUser = VerifyEmail::where('verification_token', $token)->first();
        // dd($verifyUser);
        if(isset($verifyUser) ){
            $user = $verifyUser->generaluser;
            if(!$user->is_email_verified) {
                $verifyUser->generaluser->email_verified_at = Carbon::now();
                $verifyUser->generaluser->status = 1;
                $verifyUser->generaluser->save();
                Flash::success("Your e-mail is verified. You can now login.");
            }else{
                Flash::success("Your e-mail is already verified. You can now login.");

                // $status = "Your e-mail is already verified. You can now login.";
            }
        }else{
            Flash::error("Your are cannot be identified");
            return redirect()->route('frontend.index');
        }

        return redirect()->route('frontend.index');
    }

    public function show_verification()
    {
        return view('generaluser::auth.show_verification');

    }

    public function otpverification($slug=null)
    {

        if ($slug=='sendotp') {
            # code...
            $user = auth()->guard('generaluser')->user();
            $mobile=9860627659;
            // $mobile=$user->mobile;
            $token =rand(100000,999999);
            $client = new Client();
            $message="Cake Bazar  OTP For Mobile Number Verification is:".$token." Link: ". url('/');
            $res=BackendService::send_sms($mobile,$message);
            if ($res['error']==False) {
                $user->mobile_token=$token;
                $status = $user->update();
                flash("OTP has been send to your mobile, please check")->success();

            }
            else{
                flash($res['message'])->error();
            }
        }
        return view('generaluser::auth.mobile-otp');

    }

    public function verifyphonenumber(Request $request)
    {
        $user=auth()->guard('generaluser')->user();
        if ($user->mobile_token==$request->token) {
            $user->mobile_verified_at=Carbon::now();
            $user->update();
            // Log::channel('db')->info("Phone is verified of user id=".$user->id);

            flash("Phone number is verified, congratulations")->success();

        }
        else{
            flash("INCORRECT OTP !!!, PLEASE ENTER CORRECT OTP")->error();
            return redirect()->route('generaluser.otpverification');
        }
        return redirect()->route('frontend.index');

    }



    public function resend_verification()
    {
        if(Auth::guard('generaluser')->check()){
           $generaluser= Auth::guard('generaluser')->user();
        //    $data=VerifyEmail::where('generaluser_id',$id)->first();
           $verifyUser= VerifyEmail::updateOrCreate(
            ['generaluser_id' => $generaluser->id],
            ['verification_token' => Str::random(8)]
        );

        Mail::to($generaluser->email)->send(new VerifyMail($generaluser));
        Session::flash('success', 'Email send Successfully,Please check mail to Verify your account');
        return redirect()->back();


        // $verifyUser = VerifyEmail::create([
        //     'generaluser_id' => $generaluser->id,
        //     'verification_token' => str_random(40)
        // ]);
        }
        else{
            Session::flash('error', 'Without login system cannot be proceed');
            return redirect()->back();

        }

    }

    public function changestatus($id)
    {
        $user = GeneralUser::find($id);

        if ($user->status == 0) {
            $user->status = 1;

        } else {

            $user->status = 0;
        }

        $status = $user->update();
        return redirect('generaluser');

    }

    public function verifyuserstatus($id)
    {
        $user = GeneralUser::find($id);
        // dd($user);
        $date=date('d-m-y h:i:s');

        $user->email_verified_at = $date;
        $status = $user->update();
        return redirect('generaluser');

    }
    public function generalusermakeadmin($id)
    {
        $user = GeneralUser::find($id);
        // dd($user);

        $user->is_generaluseradmin = true;
        $status = $user->update();
        return redirect('generaluser');

    }
    public function generaluserAdminDashboard()
    {
        dd("generaluser admin dashboard");
        return view('generaluser::auth.forget-password');
    }
    public function generaluserDashboard()
    {
        dd("generaluser dashboard");
        return view('generaluser::auth.forget-password');
    }
}
