<?php

namespace Modules\GeneralUser\Models;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Modules\FancyOrder\Models\FancyOrder;
use Modules\GeneralUser\Models\GeneralUser;
use Modules\GeneralUser\Models\VerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class GeneralUser extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

       //
    //    use Notifiable;
    //    use LogsActivity;
    //    use CausesActivity;
    //    use HasApiTokens;

       /**
        * The attributes that are mass assignable.
        *
        * @var array
        */
        const IMAGE_PATH = 'uploads/generaluser';
        protected $table="generalusers";

       protected $fillable = [
           'name',
            'email',
            'mobile',
            'password',
            'generaluser_type',
            'is_generaluseradmin',
            'mobile_verified_at',
            'mobile_token',
            'is_supplier',
            'status',
            'provider',
            'provider_id',
            'avatar',

       ];
    //    protected static $logFillable = true;

       protected static $logName = 'General User';
       protected static $logAttributes = ['id','name', 'email','generaluser_type','status','provider','provider_id'
    ];

       /**
        * The attributes that should be hidden for arrays.
        *
        * @var array
        */
       protected $hidden = [
           'password', 'remember_token',
       ];

       /**
        * The attributes that should be cast to native types.
        *
        * @var array
        */
       protected $casts = [
           'email_verified_at' => 'datetime',
       ];
       public function setPasswordAttribute($value)
       {
           $this->attributes['password'] = bcrypt($value);
       }
       public function verifyEmail()
       {
           return $this->hasOne(VerifyEmail::class,'generaluser_id');
       }
       public function generaluserProfile()
       {
           return $this->hasOne(GeneralUserProfile::class,'generaluser_id');
       }
       public function generalUser()
       {
           return $this->hasMany(FancyOrder::class,'generaluser_id');
       }


}
