@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Reset Password') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('generaluser.change.password.post') }}">
                        @csrf
                    {{-- <h6 class="text-muted mb-3"><u>Change your Passsword:</u></h6> --}}
                    <div class="form-group row">
                        <label for="inputPassword1" class="col-sm-4 col-form-label">Old Password</label>
                        <div class="col-sm-8">
                            <input type="password" id="old_password" class="form-control" placeholder="Enter your password" name="old_password" required autocomplete="new-password">

                            {{-- {!! Form::password('old_password', ['id'=>'old_password','placeholder'=>'Old Password','class'=>'form-control']) !!} --}}
                            @if($errors->has('old_password') )
                                <p class="msg-error">{{ $errors->first('old_password') }}</p>
                            @endif
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="inputPassword2" class="col-sm-4 col-form-label">New Password</label>
                        <div class="col-sm-8">
                            <input type="password" id="password" class="form-control" placeholder="Enter your password" name="password" required autocomplete="new-password">
                            @if($errors->has('password') )
                                <p class="msg-error">{{ $errors->first('password') }}</p>
                            @endif
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="inputPassword3" class="col-sm-4 col-form-label">Confirm New Password</label>
                        <div class="col-sm-8">
                            <input type="password" id="password_confirmation" class="form-control" placeholder="Enter your password" name="password_confirmation" required autocomplete="new-password">

                            {{-- {!! Form::password('password_confirmation', ['id'=>'password_confirmation','placeholder'=>'Confirm New Password','class'=>'form-control']) !!} --}}
                            @if($errors->has('password_confirmation') )
                                <p class="msg-error">{{ $errors->first('password_confirmation') }}</p>
                            @endif
                        </div>
                    </div>
                    <div class="form-group row mt-4">
                        <div class="col-sm-10">
                            <button type="submit" class="btn btn-secondary">Change Password</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
