@extends('layouts.master')

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            users List
        </th>

    </tr>
</table>
@endsection
@section('javascript')
@endsection

@section('content')

<div class="container">
    <div id="accordion">
        <div class="card card-default">
            <div class="card-header">
                <h4 class="card-title">
                    <a data-toggle="collapse" data-parent="#accordion" href="#collapse1">
                        <i class="glyphicon glyphicon-search text-gold"></i>
                        <b class="uniform_use_button">User Profile</b>
                    </a>
                </h4>
            </div>

            <table class="table table-bordered" id="datatable">
                <thead>
                    <tr>
                        <th>SN</th>
                        <th>Name</th>
                        <th>Email</th>
                        {{-- <th>Password</th> --}}
                        <th>Status</th>
                        <th>Verification</th>
                        <th>Is Admin</th>
                        {{-- <th>Action</th> --}}
                    </tr>
                </thead>
                <tbody>
                    @php($i=1)
                    @foreach($generalusers as $u)
                    <tr>
                        <td>{{$i++}}</td>
                        <td>{{$u->name}}</td>
                        <td>{{$u->email}}</td>
                        {{-- <td>{{$u->password}}</td> --}}

                        <td>

                            @if($u->status==0)
                            <a href="{{route('generaluserchangestatus', $u->id)}}" title="View Detail"
                                class="btn btn-small btn-danger">Inactive</a>

                            @else
                            <a href="{{route('generaluserchangestatus', $u->id)}}" title="View Detail"
                                class="btn btn-small btn-success">Active</a>

                            @endif


                        </td>
                        <td>
                            @if ( $u->email_verified_at)
                            <p>verified</p>
                            @else

                            <a href="{{route('endverifyuserstatus', $u->id)}}" title="View Detail"
                                class="btn btn-small btn-success">Verify</a>
                            @endif
                        </td>
                        <td>
                            @if ( $u->is_generaluseradmin)
                            <p>Is Admin</p>
                            @else

                            <a href="{{route('generalusermakeadmin', $u->id)}}" title="View Detail"
                                class="btn btn-small btn-success">Make Admin</a>
                            @endif
                        </td>
                        {{-- <td>
                            <a href="{{route('user.edit', $u->id)}}" class="btn btn-warning" data-toggle="tooltip"
                                title="Edit Info">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 24 24">
                                        <g fill="none" stroke="#04347a" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1" />
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3" />
                                        </g>
                                    </svg>
                               </a>
                                <form action="{{route('user.destroy', $u->id)}}" method="POST" onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete" >
                                    {{csrf_field()}}
                                        <button type="submit" class="btn btn-danger" data-toggle="tooltip" title="Delete Information" ><i class="fa fa-trash"></i></button>
                                </form>
                        </td> --}}
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>
</div>

@endsection
