<?php

use Illuminate\Support\Facades\Route;
use Modules\GeneralUser\Http\Controllers\AuthController;
use Modules\GeneralUser\Http\Controllers\GeneralUserController;
use Modules\GeneralUser\Http\Controllers\AuthRegisterController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::group([], function () {
//     Route::resource('generaluser', GeneralUserController::class)->names('generaluser');
// });


Route::get('generaluserlogin', [AuthController::class,'showloginform'])->name('generaluserlogin');
Route::post('generaluserlogin', [AuthController::class,'authenticate'])->name('authenticate');

Route::get('generaluserregister', [AuthRegisterController::class,'showRegisterForm'])->name('showRegisterForm');
Route::post('generaluserregister', [AuthRegisterController::class,'storeGeneralUser'])->name('storegeneraluser');
Route::get('generaluser-adminregister', [AuthRegisterController::class,'showadminRegisterForm'])->name('showRegisterFormadmin');

Route::post('generaluser/logout', [AuthController::class,'logout'])->name('generaluser.logout');

Route::post('generaluser', [GeneralUserController::class,'index'])->name('generaluser');
Route::post('generaluser/show/{id}', [GeneralUserController::class,'show'])->name('generaluser.show');


// Route::get('/generaluserlogin', 'AuthController@generaluserlogin')->name('generaluserlogin');
// Route::post('/generaluserlogin', 'AuthController@authenticate')->name('authenticate');

// Route::get('/generaluserregister', 'AuthRegisterController@showRegisterForm')->name('showRegisterForm');
// Route::post('/generaluserregister', 'AuthRegisterController@storeGeneralUser')->name('storegeneraluser');
// Route::get('/generaluser-adminregister', 'AuthRegisterController@showadminRegisterForm')->name('showRegisterFormadmin');

// Route::post('/generaluser-adminregister', 'AuthRegisterController@storeGeneralUseradmin')->name('storegeneraluseradmin');

// Route::post('generaluser/logout', 'AuthController@logout')->name('generaluser.logout');

// Route::get('/generaluser', 'GeneralUserController@index')->name('generaluser');

// Route::get('/generaluser/show/{id}', 'GeneralUserController@show')->name('generaluser.show');

// change password
Route::get('generaluser/change-password', [GeneralUserController::class,'changePassword'])->name('generaluser.change.password')->middleware('auth:generaluser');
Route::post('generaluser/change-password', [GeneralUserController::class,'changePasswordStore'])->name('generaluser.change.password.post')->middleware('auth:generaluser');

// Route::get('/generaluser/change-password', ['as' => 'generaluser.change.password', 'uses' => 'GeneralUserController@changePassword'])->middleware('auth:generaluser');
// Route::post('/generaluser/change-password', ['as' => 'generaluser.change.password.post', 'uses' => 'GeneralUserController@changePasswordStore'])->middleware('auth:generaluser');

// change password

//forget password
Route::get('generaluser/forget/password', [GeneralUserController::class,'forgetPassword'])->name('forget.password');
Route::post('generaluser/forget/password/post', [GeneralUserController::class,'forgetPasswordPost'])->name('forget.password.post');

// Route::get('/generaluser/forget/password', ['as' => 'forget.password', 'uses' => 'GeneralUserController@forgetPassword']);
// Route::post('/generaluser/forget/password/post', ['as' => 'forget.password.post', 'uses' => 'GeneralUserController@forgetPasswordPost']);

// reset password
Route::get('generaluser/password/reset/{token}', [GeneralUserController::class,'resetPassword'])->name('frontpassword.reset');
Route::post('generaluser/forget-password-change', [GeneralUserController::class,'resetPasswordStore'])->name('forget.password.change');

// Route::get('/generaluser/password/reset/{token}', ["as" => "frontpassword.reset", "uses" => "GeneralUserController@resetPassword"]);
// Route::post('/generaluser/forget-password-change', ['as' => 'forget.password.change', 'uses' => 'GeneralUserController@resetPasswordStore']);

Route::get('generaluser/email/verify', [GeneralUserController::class,'show_verification'])->name('generaluser_verification.notice');
Route::post('generaluser/email/resend', [GeneralUserController::class,'resend_verification'])->name('generaluser.resend_verification');

// Route::get('generaluser/email/verify', 'GeneralUserController@show_verification')->name('generaluser_verification.notice');
// Route::get('email/verify/{id}/{hash}', 'Auth\VerificationController@verify')->name('verification.verify');
// Route::post('generaluser/email/resend', 'GeneralUserController@resend_verification')->name('generaluser.resend_verification');

// verify user via email
Route::get('/generaluseruser/verify/{token}', [GeneralUserController::class,'verifyUser'])->name('generaluser.verification');
// Route::get('/generaluseruser/verify/{token}', 'GeneralUserController@verifyUser')->name('generaluser.verification');

// number verification
Route::get('/user-otpverification/{slug?}', [GeneralUserController::class,'otpverification'])->name('generaluser.otpverification')->middleware('auth:generaluser');
Route::post('verify-otp-mobile', [GeneralUserController::class,'verifyphonenumber'])->name('generaluser.verifyphonenumber')->middleware('auth:generaluser');

// Route::get('/user-otpverification/{slug?}', 'GeneralUserController@otpverification')->name('generaluser.otpverification')->middleware('auth:generaluser');
// Route::post('/verify-otp-mobile', 'GeneralUserController@verifyphonenumber')->name('generaluser.verifyphonenumber')->middleware('auth:generaluser');


// Route::group(['middleware' => ['auth','checkpermission:superadmin']], function()
Route::group([ 'middleware' => ['auth','defaultpermission:default']], function ()
{
    Route::get('generaluser', [GeneralUserController::class,'index'])->name('generaluser.index');
    Route::get('generaluser/create', [GeneralUserController::class,'create'])->name('generaluser.create');
    Route::post('generaluser/store', [GeneralUserController::class,'store'])->name('generaluser.store');
    Route::get('generaluserchangestatus/{id}', [GeneralUserController::class,'changestatus'])->name('generaluserchangestatus');
    Route::get('endverifyuserstatus/{id}', [GeneralUserController::class,'verifyuserstatus'])->name('endverifyuserstatus');
    Route::get('generalusermakeadmin/{id}', [GeneralUserController::class,'generalusermakeadmin'])->name('generalusermakeadmin');

// Route::get('generaluser', 'GeneralUserController@index')->name('generaluser.index');
// Route::get('generaluser/create', 'GeneralUserController@create')->name('generaluser.create');
// Route::post('generaluser/store', 'GeneralUserController@store')->name('generaluser.store');
// Route::get('generaluserchangestatus/{id}', 'GeneralUserController@changestatus')->name('generaluserchangestatus');
// Route::get('endverifyuserstatus/{id}', 'GeneralUserController@verifyuserstatus')->name('endverifyuserstatus');
// Route::get('generalusermakeadmin/{id}', 'GeneralUserController@generalusermakeadmin')->name('generalusermakeadmin');

});

Route::get('/generaluser/edit/{id}', [GeneralUserController::class,'edit'])->name('generaluser.edit');
Route::put('/generaluser/update/{generaluser}', [GeneralUserController::class,'update'])->name('generaluser.update');


// Route::get('/generaluser/edit/{id}', 'GeneralUserController@edit')->name('generaluser.edit');
// Route::put('/generaluser/update/{generaluser}', 'GeneralUserController@update')->name('generaluser.update');

Route::get('/generaluser/myedit', [GeneralUserController::class,'myedit'])->name('generaluser.myedit')->middleware('generaluser_mail_verified');
Route::put('/generaluser/myupdate/{generaluser}', [GeneralUserController::class,'myupdate'])->name('generaluser.myupdate');
Route::get('generaluser-profile/{id}', [GeneralUserController::class,'generaluserprofile'])->name('generaluser.generaluserprofile');

// Route::get('/generaluser/myedit', 'GeneralUserController@myedit')->name('generaluser.myedit')->middleware('generaluser_mail_verified');
// Route::put('/generaluser/myupdate/{generaluser}', 'GeneralUserController@myupdate')->name('generaluser.myupdate');

// Route::get('generaluser-profile/{id}', 'GeneralUserController@generaluserprofile')->name('generaluser.generaluserprofile');

// socialite
Route::get('auth-user/{provider}', [AuthController::class,'redirect']);
// Route::get('auth-user/{provider}', 'AuthController@redirect');
Route::get('auth-user/{provider}/callback', [AuthController::class,'callback']);

// Route::get('auth-user/{provider}/callback', 'AuthController@callback');

// socialite
