<?php

namespace Modules\Highlights\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Highlights\Entities\Highlights;
use Illuminate\Contracts\Support\Renderable;
use Modules\Highlights\Repositories\HighlightsInterface;

class HighlightsController extends Controller
{
  protected $highlights;

  public function __construct(HighlightsInterface $highlights){

        $this->highlights=$highlights;

  }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['highlights'] = $this->highlights->findAll($limit = 50, $filter, $sort);
        $data['highlights']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('highlights::highlights.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['highlights']=new Highlights();
        return view('highlights::highlights.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->highlights->upload($data['image']);
            }



            $this->highlights->save($data);
            flash("Highlights  stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('highlights.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['highlights'] = $this->highlights->find($id);
        return view('highlights::highlights.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['highlights'] = $this->highlights->find($id);
        return view('highlights::highlights.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->highlights->upload($data['image']);
            }

            $this->highlights->update($id,$data);
            flash("Highlights Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('highlights.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->highlights->delete($id);
            flash("Highlights  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('highlights.index'));
    }
    }

