<?php
namespace Modules\Highlights\Repositories;

use Modules\Highlights\Entities\Highlights;
use Modules\Highlights\Repositories\HighlightsInterface;
use Modules\Highlights\Repositories\HighlightsRepository;


class HighlightsRepository implements HighlightsInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Highlights::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Highlights::find($id);
    }

   public function getList(){
       $result = Highlights::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Highlights::create($data);
    }

    public function update($id,$data){
        $result = Highlights::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Highlights::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Highlights::FILE_PATH, $fileName);
        $fileName=Highlights::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveHighlights()
    {
       return Highlights::where('status',1)->get();
    }

}
