<?php
namespace Modules\ImageGallery\Repositories;

use Modules\ImageGallery\Entities\ImageGallery;
use Modules\ImageGallery\Repositories\ImageGalleryInterface;




class ImageGalleryRepository implements ImageGalleryInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {
        // dd($limit);


        $result = ImageGallery::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return ImageGallery::find($id);
    }
    public function unlinkImage($path){
        if(file_exists($path)){
            @unlink($path);
        }
        return true;
    }
    public function findGallery($id,$category){
        return ImageGallery::where('item_id',$id)->where('category',$category)->latest()->get();
    }

   public function getList(){
       $result = ImageGallery::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return ImageGallery::create($data);
    }

    public function update($id,$data){
        $result = ImageGallery::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return ImageGallery::destroy($id);
    }

    public function upload($file){
        // dd("hshs");
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);
        $file->move(public_path() .'/'. ImageGallery::IMAGE_PATH, $fileName);
        $fileName=ImageGallery::IMAGE_PATH. $fileName;
        // dd($filename);
        return $fileName;
    }
    public function uploadFile($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() .'/'. ImageGallery::FILE_PATH, $fileName);
        $filename=public_path() .'/'. ImageGallery::FILE_PATH. $fileName;


        return $fileName;
    }

    public function getActiveBanner()
    {
       return ImageGallery::where('status',1)->get();
    }

}
