<?php

namespace Modules\Imageinfo\Entities;

use App\User;
use Carbon\Carbon;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\Traits\CausesActivity;

class Imageinfo extends Model
{
    use LogsActivity,CausesActivity,HasSlug;
    const FILE_PATH = 'uploads/imageinfo/';
    const IMAGE_PATH = 'uploads/imageinfo/';
    // const FILE_PATH = '/uploads/imageinfo/';
    // const IMAGE_PATH = '/uploads/imageinfo/';

    protected $fillable = [
        'slug',
        'title',
        'category',
        'image',
        'file',
        'short_description',
        'description',
        'status',
        'extra1',
        'extra2',
        'extra3',
        'extra4',
        'created_by',
        'updated_by',
        'assigned_to'
    ];
    // protected static $logFillable = true;
    protected static $logName = 'ImageInfo';
    protected static $logAttributes = ['id','created_at','update_at','created_by','updated_by'];

    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }
    public function assignedUser()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->diffForHumans();
    }

}
