<?php

namespace Modules\Imageinfo\Http\Controllers;

use DateTime;
use DateTimeZone;
use Laracasts\Flash\Flash;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use App\Repositories\WatermarkInterface;
use Modules\Imageinfo\Entities\Imageinfo;
use Stevebauman\Location\Facades\Location;
use Illuminate\Contracts\Support\Renderable;
use Modules\Imageinfo\Repositories\ImageinfoInterface;
use Modules\ImageGallery\Repositories\ImageGalleryInterface;

class ImageinfoController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */

    protected $imageinfoInterface;
    protected $imagegalleryInterface;
    protected $backendInterface;

    public function __construct(
        ImageinfoInterface $imageinfoInterface,
        ImageGalleryInterface $imagegalleryInterface,
        WatermarkInterface $backendInterface

        )
    {
        $this->imageinfoInterface = $imageinfoInterface;
        $this->imagegalleryInterface = $imagegalleryInterface;
        $this->backendInterface = $backendInterface;

    }
    public function index(Request $request)
    {
        // dd($request->ip());
    //     dd($position = Location::get()
    // );
        // dd($request->header('User-Agent')    );
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        if ($request->get('end_date')) {

            $filter['end_date'] =date('Y-m-d 00:00:00', strtotime($request->get('end_date')));
            # code...
        }
        else{
            $date = new DateTime("now", new DateTimeZone('Asia/Kathmandu'));
            // $filter['end_date'] = $date->format('Y-m-d 23:59:59');
            $filter['end_date'] = date('Y-m-d 00:00:00', strtotime('+1 days'));


        }
        if ($request->get('start_date')) {

            $filter['start_date'] =date('Y-m-d 00:00:00', strtotime($request->get('start_date')));
            # code...
        }
        else{

            $filter['start_date'] = date('Y-m-d 00:00:00', strtotime('-30 days'));

        }

        $sort['by'] = $request->get('key', 'id');
        $sort['sort'] = $request->get('sort', 'DESC');

        $data['imageinfo'] = $this->imageinfoInterface->findAll($limit = 500, $filter, $sort);
        // $data['imageinfo']->appends(['title' => $filter['title']]);
        $data['imageinfo']->appends(request()->except(['page','_token']));

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        // Alert::success('Success Title', 'Success Message');


        return view('imageinfo::imageinfo.index',compact('sort','filter'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['imageinfo']=new Imageinfo();
        return view('imageinfo::imageinfo.create',$data);
    }


    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $datainfo = $request->all();
        // dd($data);

        try{
            // if($request->hasFile('image')){
            //     $data['image'] = $this->imageinfoInterface->upload($data['image']);
            // }
            if($request->hasFile('file')){
                $datainfo['file'] = $this->imageinfoInterface->uploadFile($datainfo['file']);
            }
            $datainfo['image']=null;

            // $datainfo['slug']=$this->getSlug($datainfo['title']);


            $storedinfo=$this->imageinfoInterface->save($datainfo);
            // dd()

            if($request->hasFile('image') && $storedinfo){
                foreach($request->file('image') as $file)
            {
                $data['image'] = $this->imagegalleryInterface->upload($file);
                $data['category']='imageinfo';
                $data['item_id']=$storedinfo->id;
                if ($data['image']) {
                    # code...
                    $this->backendInterface->TextWatermark($data['image']);
                }
                // dd($data['image']);
                $result=$this->imagegalleryInterface->save($data);


                // $this->backendInterface->TextWatermark($data);


            }

            }
            // Session::flash('success', 'Information Added successfully.');
            toast('Information Added successfully.','success');


            // alertify()->success('imageinfo Created Successfully');

        }catch(\Throwable  $e){
            // alertify($e->getMessage())->error();
            Session::flash('error', $e->getMessage());
            // toast('Information Added successfully.','error');

        }
        return redirect(route('imageinfo.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Response
     */
    public function show($id)
    {
        $data['imageinfo'] = $this->imageinfoInterface->find($id);
        // $id=$request->imageinfo_id;

         $data['imagegallery'] = $this->imagegalleryInterface->findGallery($id,'imageinfo');
        //  return view('imagegallery::imagegallery.index',$data);
        return view('imageinfo::imageinfo.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Response
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['imageinfo'] = $this->imageinfoInterface->find($id);
        return view('imageinfo::imageinfo.create',$data);

    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();

        try{


            // if($request->hasFile('image')){
            //     $data['image'] = $this->imageinfoInterface->upload($data['image']);
            // }
            if($request->hasFile('image')){
                foreach($request->file('image') as $file)
            {
                $data['image'] = $this->imagegalleryInterface->upload($file);
                $data['category']='imageinfo';
                $data['item_id']=$id;
                if ($data['image']) {
                    # code...
                    $this->backendInterface->TextWatermark($data['image']);
                }
                $this->imagegalleryInterface->save($data);

            }

            }
            if($request->hasFile('file')){
                $data['file'] = $this->imageinfoInterface->uploadFile($data['file']);
            }


            $this->imageinfoInterface->update($id,$data);
            // Session::flash('success', 'Information Updated successfully.');
            // flash("Information Saved Successfully")->success();
            // Flash::success("Password Successfully Updated!");
            toast('Information Updated successfully.','success');


        }catch(\Throwable $e){
            // Session::flash('error', 'Information Cannot be Update');
            flash($e->getMessage())->error();
            // Flash::error($e->getMessage());

        }

        return redirect(route('imageinfo.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Response
     */
    public function destroy($id)
    {
        try{
            $imagegallery = $this->imagegalleryInterface->findGallery($id,'imageinfo');
            $data = $this->imageinfoInterface->find($id);
            $filepath=$data->file;

            $deleteStatus=$this->imageinfoInterface->delete($id);
            if ($deleteStatus) {
                $this->imagegalleryInterface->unlinkImage($filepath);
                foreach($imagegallery as $g){
                    $path=$g->image;
                    $deleteStatusgallery=$this->imagegalleryInterface->delete($g->id);
                    if ($deleteStatusgallery) {
                        # code...
                        $this->imagegalleryInterface->unlinkImage($path);
                    }

                }
            }

            flash("Information Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('imageinfo.index'));
    }
    protected function changeimagestatus(Request $request)
    {
        $id=$request->get('id');
        $data = Imageinfo::find($id);

        if ($data->status == 0) {
            $data->status = 1;
        } else {
            $data->status = 0;
        }
        $is_success = $data->update();
        $status=$data->status;

        $msg="status changed successfully !!!";
        $code=200;
        $json = json_encode(['success' => 1, 'msg' => $msg, 'id' => $id,'code'=>$code,'status'=>$status]);

        // return response()->json(['error' => false, 'message' => $msg, $data], $code);

        return $json;

    }
    // protected function getSlug($string)
    // {
    //     $string = strtolower($string);
    //     $string = html_entity_decode($string);
    //     $string = str_replace(array('ä', 'ü', 'ö', 'ß'), array('ae', 'ue', 'oe', 'ss'), $string);
    //     $string = preg_replace('#[^\w\säüöß]#', null, $string);
    //     $string = preg_replace('#[\s]{2,}#', ' ', $string);
    //     $string = str_replace(array(' '), array('-'), $string);
    //     return $string;
    // }
}

