<?php
namespace Modules\Imageinfo\Repositories;

use Modules\Imageinfo\Entities\Imageinfo;
use Modules\Imageinfo\Repositories\ImageinfoInterface;




class ImageinfoRepository implements ImageinfoInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {
        // dd($limit);
        $result = Imageinfo::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
           if (isset($filter['start_date'])) {
               $query->where('created_at','>=', $filter['start_date']);
           }

           if (isset($filter['end_date'])) {
               $query->where('created_at','<=', $filter['end_date']);
           }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Imageinfo::find($id);
    }

   public function getList(){
       $result = Imageinfo::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Imageinfo::create($data);
    }

    public function update($id,$data){
        $result = Imageinfo::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Imageinfo::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() .'/'. Imageinfo::IMAGE_PATH, $fileName);

        return $fileName;
    }
    public function uploadFile($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() .'/'. Imageinfo::FILE_PATH, $fileName);

        return $fileName;
    }

    public function getActiveBanner()
    {
       return Imageinfo::where('status',1)->get();
    }

}
