@extends('layouts.backmaster')

@section('title', 'Imageinfo')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Imageinfo
        </th>
        <th class="float-right">
            <a href="{{route('imageinfo.index')}}" class="btn btn-primary pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('seccontent')

@inject('backService', '\App\ServiceContainer\BackendService')
@php
    $userlist=$backService->getActiveuser();
@endphp
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(!isset($imageinfo->id))
                <form method="post" action="{{route('imageinfo.store')}}" enctype="multipart/form-data" class="valid_form">
                    <input type="hidden" class="form-control" name="created_by" value="{{Auth::user()->id}}">

                    @else
                    <form method="post" action="{{route('imageinfo.update',$imageinfo)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">
                        {{-- <input type="hidden" name="_method" value="put"> --}}
                        {{method_field('PUT')}}

                        <input type="hidden" class="form-control" name="updated_by" value="{{Auth::user()->id}}">
                        {{-- <input type="hidden" class="form-control" name="created_by" value="{{$imageinfo->created_by}}">
                        --}}
                        @endif
                        {{csrf_field()}}

                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Title:</label>
                                    <input type="text" name="title" class="form-control"
                                        value="{{old('title',$imageinfo->title)}}" required>
                                    @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            {{-- <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="category">Category:</label>
                                    <input type="category" name="category" class="form-control"
                                        value="{{old('category',$imageinfo->category)}}" required>
                                    @if ($errors->has('category'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('category') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div> --}}
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>File :</label>
                                    <input type="file" class="form-control" name="file" value="{{$imageinfo->file}}">
                                    @if(isset($imageinfo->id) && $imageinfo->file!=null)
                                        <a href="{{asset('/uploads/imageinfo/'.$imageinfo->file)}}" target="_blank">Previously chosen File</a>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image/Images :</label>
                                    <input type="file" class="form-control" name="image[]" value="" multiple
                                        data-default-file="{{ ($imageinfo->image) ? asset('/uploads/imageinfo/'.$imageinfo->image) : '' }}">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-xs-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea type="text" name="description" class="form-control my-editor"
                                        required>{{old('description',$imageinfo->description)}}</textarea>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$imageinfo->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Assign To:</label>
                                    <select class="form-control myselect" name="assigned_to">
                                        <option value=""></option>
                                        @foreach ($userlist as $u)

                                    <option value="{{$u->id}}" {{$imageinfo->assigned_to==$u->id?'selected':''}}>{{$u->name}}</option>

                                        @endforeach

                                    </select>
                                    </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                              <h2 class="mt-4">Standalone Image Button</h2>
                              <div class="input-group">
                                <span class="input-group-btn">
                                  <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary text-white">
                                    <i class="fa fa-picture-o"></i> Choose
                                  </a>
                                </span>
                                <input id="thumbnail" class="form-control" type="text" name="filepath">
                              </div>
                              <div id="holder" style="margin-top:15px;max-height:100px;"></div>

                            </div>
                          </div>

                          <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-success float-right">Save</button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection

